/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.renderdata.DisplaySide;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;

public class ItemDisplaySettingsContainer
extends SettingsContainerBase<ItemDisplaySettingsCategory> {
    private static final String COLOR_TAG = "color";
    private static final String DISPLAY_SIDE_TAG = "displaySide";
    private static final String SELECT_SLOT_TAG = "selectSlot";
    private static final String UNSELECT_SLOT_TAG = "unselectSlot";
    private static final String ROTATE_CLOCKWISE_TAG = "rotateClockwise";
    private static final String ROTATE_COUNTER_CLOCKWISE_TAG = "rotateCounterClockwise";

    public ItemDisplaySettingsContainer(SettingsContainerMenu<?> settingsContainer, String categoryName, ItemDisplaySettingsCategory category) {
        super(settingsContainer, categoryName, category);
    }

    @Override
    public void handlePacket(CompoundTag data) {
        if (data.contains(SELECT_SLOT_TAG)) {
            this.selectSlot(data.getInt(SELECT_SLOT_TAG));
        } else if (data.contains(UNSELECT_SLOT_TAG)) {
            this.unselectSlot(data.getInt(UNSELECT_SLOT_TAG));
        } else if (data.contains(ROTATE_CLOCKWISE_TAG)) {
            this.rotateClockwise(data.getInt(ROTATE_CLOCKWISE_TAG));
        } else if (data.contains(ROTATE_COUNTER_CLOCKWISE_TAG)) {
            this.rotateCounterClockwise(data.getInt(ROTATE_COUNTER_CLOCKWISE_TAG));
        } else if (data.contains(COLOR_TAG)) {
            this.setColor(DyeColor.byId((int)data.getInt(COLOR_TAG)));
        } else if (data.contains(DISPLAY_SIDE_TAG)) {
            ((ItemDisplaySettingsCategory)this.getCategory()).setDisplaySide(DisplaySide.fromName(data.getString(DISPLAY_SIDE_TAG)));
        }
    }

    public void unselectSlot(int slotIndex) {
        if (!this.isSlotSelected(slotIndex)) {
            return;
        }
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).unselectSlot(slotIndex);
        } else {
            ((ItemDisplaySettingsCategory)this.getCategory()).unselectSlot(slotIndex);
            this.sendIntToServer(UNSELECT_SLOT_TAG, slotIndex);
        }
    }

    public void selectSlot(int slotIndex) {
        if (this.isSlotSelected(slotIndex)) {
            return;
        }
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).selectSlot(slotIndex);
        } else {
            ((ItemDisplaySettingsCategory)this.getCategory()).selectSlot(slotIndex);
            this.sendIntToServer(SELECT_SLOT_TAG, slotIndex);
        }
    }

    public void rotateClockwise(int slotIndex) {
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).rotate(slotIndex, true);
        } else {
            this.sendIntToServer(ROTATE_CLOCKWISE_TAG, slotIndex);
        }
    }

    public void rotateCounterClockwise(int slotIndex) {
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).rotate(slotIndex, false);
        } else {
            this.sendIntToServer(ROTATE_COUNTER_CLOCKWISE_TAG, slotIndex);
        }
    }

    public void setColor(DyeColor color) {
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).setColor(color);
        } else {
            this.sendIntToServer(COLOR_TAG, color.getId());
        }
    }

    public void setDisplaySide(DisplaySide displaySide) {
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).setDisplaySide(displaySide);
        } else {
            this.sendStringToServer(DISPLAY_SIDE_TAG, displaySide.getSerializedName());
        }
    }

    public boolean isSlotSelected(int slotIndex) {
        return ((ItemDisplaySettingsCategory)this.getCategory()).getSlots().contains(slotIndex);
    }

    public DyeColor getColor() {
        return ((ItemDisplaySettingsCategory)this.getCategory()).getColor();
    }

    public int getRotation(int slotIndex) {
        return ((ItemDisplaySettingsCategory)this.getCategory()).getRotation(slotIndex);
    }

    public int getFirstSelectedSlot() {
        List<Integer> slots = ((ItemDisplaySettingsCategory)this.getCategory()).getSlots();
        return slots.isEmpty() ? -1 : slots.get(0);
    }

    public DisplaySide getDisplaySide() {
        return ((ItemDisplaySettingsCategory)this.getCategory()).getDisplaySide();
    }
}

