/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogicBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedcore.util.FilterItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class FilterLogic
extends FilterLogicBase {
    private final int filterSlotCount;
    private final Predicate<ItemStack> isItemValid;
    private ObservableFilterItemStackHandler filterHandler = null;
    private boolean emptyAllowListMatchesEverything = false;

    public FilterLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, int filterSlotCount) {
        this(upgrade, saveHandler, filterSlotCount, s -> true, "");
    }

    public FilterLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, int filterSlotCount, String parentTagKey) {
        this(upgrade, saveHandler, filterSlotCount, s -> true, parentTagKey);
    }

    public FilterLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, int filterSlotCount, Predicate<ItemStack> isItemValid) {
        this(upgrade, saveHandler, filterSlotCount, isItemValid, "");
    }

    public FilterLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, int filterSlotCount, Predicate<ItemStack> isItemValid, String parentTagKey) {
        super(upgrade, saveHandler, parentTagKey);
        this.filterSlotCount = filterSlotCount;
        this.isItemValid = isItemValid;
    }

    public void setEmptyAllowListMatchesEverything() {
        this.emptyAllowListMatchesEverything = true;
    }

    public ObservableFilterItemStackHandler getFilterHandler() {
        if (this.filterHandler == null) {
            this.filterHandler = new ObservableFilterItemStackHandler();
            NBTHelper.getCompound(this.upgrade, this.parentTagKey, "filters").ifPresent(this.filterHandler::deserializeNBT);
        }
        return this.filterHandler;
    }

    public boolean matchesFilter(ItemStack stack) {
        if (this.isAllowList()) {
            if (this.getPrimaryMatch() == PrimaryMatch.TAGS) {
                return this.isTagMatch(stack);
            }
            return this.getFilterHandler().hasOnlyEmptyFilters() && this.emptyAllowListMatchesEverything || InventoryHelper.iterate((IItemHandler)this.getFilterHandler(), (slot, filter) -> this.stackMatchesFilter(stack, (ItemStack)filter), () -> false, returnValue -> returnValue) != false;
        }
        if (this.getPrimaryMatch() == PrimaryMatch.TAGS) {
            return !this.isTagMatch(stack);
        }
        return this.getFilterHandler().hasOnlyEmptyFilters() || InventoryHelper.iterate((IItemHandler)this.getFilterHandler(), (slot, filter) -> !this.stackMatchesFilter(stack, (ItemStack)filter), () -> true, returnValue -> returnValue == false) != false;
    }

    private boolean isTagMatch(ItemStack stack) {
        if (this.shouldMatchAnyTag()) {
            return this.anyTagMatches(stack.getTags());
        }
        return this.allTagsMatch(stack.getTags());
    }

    private boolean allTagsMatch(Stream<TagKey<Item>> tagsStream) {
        if (this.tagKeys == null) {
            this.initTags();
        }
        Set tags = tagsStream.collect(Collectors.toSet());
        for (TagKey tagName : this.tagKeys) {
            if (tags.contains(tagName)) continue;
            return false;
        }
        return true;
    }

    private boolean anyTagMatches(Stream<TagKey<Item>> tags) {
        if (this.tagKeys == null) {
            this.initTags();
        }
        return tags.anyMatch(t -> this.tagKeys.contains(t));
    }

    public class ObservableFilterItemStackHandler
    extends FilterItemStackHandler {
        private IntConsumer onSlotChange;

        public ObservableFilterItemStackHandler() {
            super(FilterLogic.this.filterSlotCount);
            this.onSlotChange = s -> {};
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            NBTHelper.setCompoundNBT(FilterLogic.this.upgrade, FilterLogic.this.parentTagKey, "filters", this.serializeNBT());
            FilterLogic.this.save();
            this.onSlotChange.accept(slot);
        }

        public void setOnSlotChange(IntConsumer onSlotChange) {
            this.onSlotChange = onSlotChange;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.setSize(FilterLogic.this.filterSlotCount);
            ListTag tagList = nbt.getList("Items", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag itemTags = tagList.getCompound(i);
                int slot = itemTags.getInt("Slot");
                if (slot < 0 || slot >= this.stacks.size()) continue;
                ItemStack stack = ItemStack.of((CompoundTag)itemTags);
                this.stacks.set(slot, (Object)stack);
            }
            this.onLoad();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.isEmpty() || this.doesNotContain(stack) && FilterLogic.this.isItemValid.test(stack);
        }

        private boolean doesNotContain(ItemStack stack) {
            return !InventoryHelper.hasItem((IItemHandler)this, s -> ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack));
        }
    }
}

