/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedcore.util.ItemStackHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class FilterLogicBase {
    protected final ItemStack upgrade;
    protected final Consumer<ItemStack> saveHandler;
    protected final String parentTagKey;
    private boolean allowListDefault = false;
    @Nullable
    protected Set<TagKey<Item>> tagKeys = null;

    public FilterLogicBase(ItemStack upgrade, Consumer<ItemStack> saveHandler, String parentTagKey) {
        this.upgrade = upgrade;
        this.saveHandler = saveHandler;
        this.parentTagKey = parentTagKey;
    }

    public String getParentTagKey() {
        return this.parentTagKey;
    }

    public void setAllowByDefault(boolean allowListDefault) {
        this.allowListDefault = allowListDefault;
    }

    protected void save() {
        this.saveHandler.accept(this.upgrade);
    }

    public boolean stackMatchesFilter(ItemStack stack, ItemStack filter) {
        if (filter.isEmpty()) {
            return false;
        }
        PrimaryMatch primaryMatch = this.getPrimaryMatch();
        if (primaryMatch == PrimaryMatch.MOD ? !BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace().equals(BuiltInRegistries.ITEM.getKey((Object)filter.getItem()).getNamespace()) : primaryMatch == PrimaryMatch.ITEM && stack.getItem() != filter.getItem()) {
            return false;
        }
        if (this.shouldMatchDurability() && stack.getDamageValue() != filter.getDamageValue()) {
            return false;
        }
        return !this.shouldMatchNbt() || ItemStackHelper.areItemStackTagsEqualIgnoreDurability(stack, filter);
    }

    public Set<TagKey<Item>> getTagKeys() {
        if (this.tagKeys == null) {
            this.initTags();
        }
        return Collections.unmodifiableSet(this.tagKeys);
    }

    public void addTag(TagKey<Item> tagName) {
        if (this.tagKeys == null) {
            this.initTags();
        }
        this.tagKeys.add(tagName);
        this.serializeTags();
        this.save();
    }

    private void serializeTags() {
        if (this.tagKeys == null) {
            return;
        }
        NBTHelper.setList(this.upgrade, this.parentTagKey, "tags", this.tagKeys, t -> StringTag.valueOf((String)t.location().toString()));
    }

    public void removeTagName(TagKey<Item> tagName) {
        if (this.tagKeys == null) {
            this.initTags();
        }
        this.tagKeys.remove(tagName);
        this.serializeTags();
        this.save();
    }

    protected void initTags() {
        this.tagKeys = NBTHelper.getCollection(this.upgrade, this.parentTagKey, "tags", (byte)8, elementNbt -> Optional.of(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation(elementNbt.getAsString()))), () -> new TreeSet<TagKey>(Comparator.comparing(TagKey::location))).orElse(new TreeSet<TagKey>(Comparator.comparing(TagKey::location)));
    }

    public void setAllowList(boolean isAllowList) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "isAllowList", isAllowList);
        this.save();
    }

    public boolean isAllowList() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "isAllowList").orElse(this.allowListDefault);
    }

    public boolean shouldMatchDurability() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "matchDurability").orElse(false);
    }

    public void setMatchDurability(boolean matchDurability) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "matchDurability", matchDurability);
        this.save();
    }

    public void setMatchNbt(boolean matchNbt) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "matchNbt", matchNbt);
        this.save();
    }

    public boolean shouldMatchNbt() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "matchNbt").orElse(false);
    }

    public void setPrimaryMatch(PrimaryMatch primaryMatch) {
        NBTHelper.setEnumConstant(this.upgrade, this.parentTagKey, "primaryMatch", primaryMatch);
        this.save();
    }

    public PrimaryMatch getPrimaryMatch() {
        return NBTHelper.getEnumConstant(this.upgrade, this.parentTagKey, "primaryMatch", PrimaryMatch::fromName).orElse(PrimaryMatch.ITEM);
    }

    public boolean shouldMatchAnyTag() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "matchAnyTag").orElse(true);
    }

    public void setMatchAnyTag(boolean matchAnyTag) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "matchAnyTag", matchAnyTag);
        this.save();
    }
}

