/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.crafting;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ICraftingContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SlotSuppliedHandler;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingItemHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class CraftingUpgradeContainer
extends UpgradeContainerBase<CraftingUpgradeWrapper, CraftingUpgradeContainer>
implements ICraftingContainer {
    private static final String DATA_SHIFT_CLICK_INTO_STORAGE = "shiftClickIntoStorage";
    private static final String DATA_SELECT_RESULT = "selectResult";
    private final ResultContainer craftResult = new ResultContainer();
    private final CraftingItemHandler craftMatrix;
    private final ResultSlot craftingResultSlot;
    @Nullable
    private RecipeHolder<CraftingRecipe> lastRecipe = null;
    private List<RecipeHolder<CraftingRecipe>> matchedCraftingRecipes = new ArrayList<RecipeHolder<CraftingRecipe>>();
    private final List<ItemStack> matchedCraftingResults = new ArrayList<ItemStack>();
    private int selectedCraftingResultIndex = 0;

    public CraftingUpgradeContainer(final Player player, int upgradeContainerId, CraftingUpgradeWrapper upgradeWrapper, UpgradeContainerType<CraftingUpgradeWrapper, CraftingUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
        int slot;
        for (slot = 0; slot < upgradeWrapper.getInventory().getSlots(); ++slot) {
            this.slots.add(new SlotSuppliedHandler(upgradeWrapper::getInventory, slot, -100, -100){

                public void setChanged() {
                    super.setChanged();
                    CraftingUpgradeContainer.this.updateCraftingResult(player.level(), player, (CraftingContainer)CraftingUpgradeContainer.this.craftMatrix, CraftingUpgradeContainer.this.craftResult, CraftingUpgradeContainer.this.craftingResultSlot);
                    CraftingUpgradeContainer.this.craftMatrix.setChanged();
                }
            });
        }
        this.craftMatrix = new CraftingItemHandler(upgradeWrapper::getInventory, this::onCraftMatrixChanged);
        this.craftingResultSlot = new ResultSlot(player, (CraftingContainer)this.craftMatrix, (Container)this.craftResult, slot, -100, -100){

            public void onTake(Player thePlayer, ItemStack stack) {
                ItemStack remainingStack = this.getItem();
                this.checkTakeAchievements(stack);
                CommonHooks.setCraftingPlayer((Player)thePlayer);
                NonNullList items = CraftingUpgradeContainer.this.lastRecipe != null && ((CraftingRecipe)CraftingUpgradeContainer.this.lastRecipe.value()).matches((Container)CraftingUpgradeContainer.this.craftMatrix, player.level()) ? ((CraftingRecipe)CraftingUpgradeContainer.this.lastRecipe.value()).getRemainingItems((Container)CraftingUpgradeContainer.this.craftMatrix) : CraftingUpgradeContainer.this.craftMatrix.getItems();
                CommonHooks.setCraftingPlayer(null);
                for (int i = 0; i < items.size(); ++i) {
                    ItemStack itemstack = CraftingUpgradeContainer.this.craftMatrix.getItem(i);
                    ItemStack itemstack1 = items.get(i);
                    if (!itemstack.isEmpty()) {
                        CraftingUpgradeContainer.this.craftMatrix.removeItem(i, 1);
                        itemstack = CraftingUpgradeContainer.this.craftMatrix.getItem(i);
                    }
                    if (itemstack1.isEmpty()) continue;
                    if (itemstack.isEmpty()) {
                        CraftingUpgradeContainer.this.craftMatrix.setItem(i, itemstack1);
                        continue;
                    }
                    if (ItemStack.isSameItemSameTags((ItemStack)itemstack, (ItemStack)itemstack1)) {
                        itemstack1.grow(itemstack.getCount());
                        CraftingUpgradeContainer.this.craftMatrix.setItem(i, itemstack1);
                        continue;
                    }
                    if (player.getInventory().add(itemstack1)) continue;
                    player.drop(itemstack1, false);
                }
                if (!remainingStack.isEmpty()) {
                    player.drop(remainingStack, false);
                }
            }

            public void setChanged() {
                super.setChanged();
                if (player.level().isClientSide()) {
                    CraftingUpgradeContainer.this.matchedCraftingRecipes.clear();
                    CraftingUpgradeContainer.this.matchedCraftingResults.clear();
                    if (!this.getItem().isEmpty()) {
                        CraftingUpgradeContainer.this.matchedCraftingRecipes = RecipeHelper.safeGetRecipesFor(RecipeType.CRAFTING, CraftingUpgradeContainer.this.craftMatrix, player.level());
                        int resultIndex = 0;
                        for (RecipeHolder<CraftingRecipe> craftingRecipe : CraftingUpgradeContainer.this.matchedCraftingRecipes) {
                            ItemStack result = ((CraftingRecipe)craftingRecipe.value()).assemble((Container)CraftingUpgradeContainer.this.craftMatrix, player.level().registryAccess());
                            CraftingUpgradeContainer.this.matchedCraftingResults.add(result);
                            if (ItemHandlerHelper.canItemStacksStack((ItemStack)this.getItem(), (ItemStack)result)) {
                                CraftingUpgradeContainer.this.selectedCraftingResultIndex = resultIndex;
                            }
                            ++resultIndex;
                        }
                    }
                }
            }
        };
        this.slots.add(this.craftingResultSlot);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.onCraftMatrixChanged((Container)this.craftMatrix);
    }

    private void onCraftMatrixChanged(Container iInventory) {
        this.updateCraftingResult(this.player.level(), this.player, (CraftingContainer)this.craftMatrix, this.craftResult, this.craftingResultSlot);
    }

    private void updateCraftingResult(Level level, Player player, CraftingContainer inventory, ResultContainer inventoryResult, ResultSlot craftingResultSlot) {
        if (!level.isClientSide) {
            ServerPlayer serverplayerentity = (ServerPlayer)player;
            ItemStack itemstack = ItemStack.EMPTY;
            if (this.lastRecipe != null && ((CraftingRecipe)this.lastRecipe.value()).matches((Container)inventory, level)) {
                itemstack = ((CraftingRecipe)this.lastRecipe.value()).assemble((Container)inventory, level.registryAccess());
            } else {
                List recipes = RecipeHelper.safeGetRecipesFor(RecipeType.CRAFTING, inventory, level);
                if (!recipes.isEmpty()) {
                    this.matchedCraftingRecipes = recipes;
                    this.matchedCraftingResults.clear();
                    this.selectedCraftingResultIndex = 0;
                    RecipeHolder<CraftingRecipe> craftingRecipe = this.matchedCraftingRecipes.get(0);
                    if (inventoryResult.setRecipeUsed(level, serverplayerentity, craftingRecipe)) {
                        this.lastRecipe = craftingRecipe;
                        itemstack = ((CraftingRecipe)this.lastRecipe.value()).assemble((Container)inventory, level.registryAccess());
                        this.matchedCraftingResults.add(itemstack.copy());
                    } else {
                        this.lastRecipe = null;
                    }
                    for (int i = 1; i < this.matchedCraftingRecipes.size(); ++i) {
                        this.matchedCraftingResults.add(((CraftingRecipe)this.matchedCraftingRecipes.get(i).value()).assemble((Container)inventory, level.registryAccess()));
                    }
                }
            }
            craftingResultSlot.set(itemstack);
        }
    }

    public List<ItemStack> getMatchedCraftingResults() {
        return this.matchedCraftingResults;
    }

    public void selectNextCraftingResult() {
        if (this.matchedCraftingResults.size() > 1) {
            this.selectCraftingResult((this.selectedCraftingResultIndex + 1) % this.matchedCraftingResults.size());
        }
    }

    public void selectPreviousCraftingResult() {
        if (this.matchedCraftingResults.size() > 1) {
            this.selectCraftingResult((this.selectedCraftingResultIndex + this.matchedCraftingResults.size() - 1) % this.matchedCraftingResults.size());
        }
    }

    public void selectCraftingResult(int resultIndex) {
        if (resultIndex < 0 || resultIndex >= this.matchedCraftingResults.size()) {
            return;
        }
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.selectedCraftingResultIndex = resultIndex;
            this.lastRecipe = this.matchedCraftingRecipes.get(resultIndex);
            ItemStack result = this.matchedCraftingResults.get(resultIndex).copy();
            this.craftingResultSlot.set(result);
            this.craftResult.setRecipeUsed(this.player.level(), serverPlayer, this.lastRecipe);
        } else {
            this.sendDataToServer(() -> NBTHelper.putInt(new CompoundTag(), DATA_SELECT_RESULT, resultIndex));
        }
    }

    @Override
    public void handlePacket(CompoundTag data) {
        if (data.contains(DATA_SHIFT_CLICK_INTO_STORAGE)) {
            this.setShiftClickIntoStorage(data.getBoolean(DATA_SHIFT_CLICK_INTO_STORAGE));
        } else if (data.contains(DATA_SELECT_RESULT)) {
            this.selectCraftingResult(data.getInt(DATA_SELECT_RESULT));
        }
    }

    @Override
    public ItemStack getSlotStackToTransfer(Slot slot) {
        if (slot == this.craftingResultSlot) {
            ItemStack slotStack = slot.getItem();
            slotStack.getItem().onCraftedBy(slotStack, this.player.level(), this.player);
            return slotStack;
        }
        return super.getSlotStackToTransfer(slot);
    }

    @Override
    public List<Slot> getRecipeSlots() {
        return this.slots.subList(0, 9);
    }

    @Override
    public Container getCraftMatrix() {
        return this.craftMatrix;
    }

    @Override
    public void setRecipeUsed(ResourceLocation recipeId) {
        if (this.lastRecipe != null && this.lastRecipe.id().equals((Object)recipeId)) {
            return;
        }
        this.player.level().getRecipeManager().byKey(recipeId).filter(r -> r.value().getType() == RecipeType.CRAFTING).map(r -> r).ifPresent(recipe -> {
            this.lastRecipe = recipe;
            for (int i = 0; i < this.matchedCraftingRecipes.size(); ++i) {
                if (!this.matchedCraftingRecipes.get(i).id().equals((Object)recipeId)) continue;
                this.selectCraftingResult(i);
                return;
            }
        });
    }

    public boolean shouldShiftClickIntoStorage() {
        return ((CraftingUpgradeWrapper)this.upgradeWrapper).shouldShiftClickIntoStorage();
    }

    public void setShiftClickIntoStorage(boolean shiftClickIntoStorage) {
        ((CraftingUpgradeWrapper)this.upgradeWrapper).setShiftClickIntoStorage(shiftClickIntoStorage);
        this.sendDataToServer(() -> NBTHelper.putBoolean(new CompoundTag(), DATA_SHIFT_CLICK_INTO_STORAGE, shiftClickIntoStorage));
    }

    @Override
    public boolean mergeIntoStorageFirst(Slot slot) {
        return !(slot instanceof ResultSlot) || this.shouldShiftClickIntoStorage();
    }

    @Override
    public boolean allowsPickupAll(Slot slot) {
        return slot != this.craftingResultSlot;
    }
}

