/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.feeding;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.feeding.FeedingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.feeding.HungerLevel;
import net.p3pp3rf1y.sophisticatedcore.util.CapabilityHelper;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class FeedingUpgradeWrapper
extends UpgradeWrapperBase<FeedingUpgradeWrapper, FeedingUpgradeItem>
implements ITickableUpgrade,
IFilteredUpgrade {
    private static final int COOLDOWN = 100;
    private static final int STILL_HUNGRY_COOLDOWN = 10;
    private static final int FEEDING_RANGE = 3;
    private final FilterLogic filterLogic;

    public FeedingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((FeedingUpgradeItem)this.upgradeItem).getFilterSlotCount(), ItemStack::isEdible);
    }

    @Override
    public void tick(@Nullable LivingEntity entity, Level level, BlockPos pos) {
        if (this.isInCooldown(level) || entity != null && !(entity instanceof Player)) {
            return;
        }
        boolean hungryPlayer = false;
        if (entity == null) {
            AtomicBoolean stillHungryPlayer = new AtomicBoolean(false);
            level.getEntities((EntityTypeTest)EntityType.PLAYER, new AABB(pos).inflate(3.0), p -> true).forEach(p -> stillHungryPlayer.set(stillHungryPlayer.get() || this.feedPlayerAndGetHungry((Player)p, level)));
            hungryPlayer = stillHungryPlayer.get();
        } else if (this.feedPlayerAndGetHungry((Player)entity, level)) {
            hungryPlayer = true;
        }
        if (hungryPlayer) {
            this.setCooldown(level, 10);
            return;
        }
        this.setCooldown(level, 100);
    }

    private boolean feedPlayerAndGetHungry(Player player, Level level) {
        int hungerLevel = 20 - player.getFoodData().getFoodLevel();
        if (hungerLevel == 0) {
            return false;
        }
        return this.tryFeedingFoodFromStorage(level, hungerLevel, player) && player.getFoodData().getFoodLevel() < 20;
    }

    private boolean tryFeedingFoodFromStorage(Level level, int hungerLevel, Player player) {
        boolean isHurt = player.getHealth() < player.getMaxHealth() - 0.1f;
        ITrackedContentsItemHandler inventory = this.storageWrapper.getInventoryForUpgradeProcessing();
        AtomicBoolean fedPlayer = new AtomicBoolean(false);
        InventoryHelper.iterate((IItemHandler)inventory, (slot, stack) -> {
            if (FeedingUpgradeWrapper.isEdible(stack, (LivingEntity)player) && this.filterLogic.matchesFilter((ItemStack)stack) && (this.isHungryEnoughForFood(hungerLevel, (ItemStack)stack, player) || this.shouldFeedImmediatelyWhenHurt() && hungerLevel > 0 && isHurt)) {
                ItemStack mainHandItem = player.getMainHandItem();
                player.getInventory().items.set(player.getInventory().selected, stack);
                if (stack.use(level, player, InteractionHand.MAIN_HAND).getResult() == InteractionResult.CONSUME) {
                    player.getInventory().items.set(player.getInventory().selected, (Object)mainHandItem);
                    ItemStack containerItem = EventHooks.onItemUseFinish((LivingEntity)player, (ItemStack)stack.copy(), (int)0, (ItemStack)stack.getItem().finishUsingItem(stack, level, (LivingEntity)player));
                    inventory.setStackInSlot(slot.intValue(), (ItemStack)stack);
                    if (!ItemStack.matches((ItemStack)containerItem, (ItemStack)stack)) {
                        CapabilityHelper.runOnCapability((Entity)player, Capabilities.ItemHandler.ENTITY, null, playerInventory -> InventoryHelper.insertOrDropItem(player, containerItem, new IItemHandler[]{inventory, playerInventory}));
                    }
                    fedPlayer.set(true);
                    return true;
                }
                player.getInventory().items.set(player.getInventory().selected, (Object)mainHandItem);
            }
            return false;
        }, () -> false, ret -> ret);
        return fedPlayer.get();
    }

    private static boolean isEdible(ItemStack stack, LivingEntity player) {
        if (!stack.isEdible()) {
            return false;
        }
        FoodProperties foodProperties = stack.getItem().getFoodProperties(stack, player);
        return foodProperties != null && foodProperties.getNutrition() >= 1;
    }

    private boolean isHungryEnoughForFood(int hungerLevel, ItemStack stack, Player player) {
        FoodProperties foodProperties = stack.getItem().getFoodProperties(stack, (LivingEntity)player);
        if (foodProperties == null) {
            return false;
        }
        HungerLevel feedAtHungerLevel = this.getFeedAtHungerLevel();
        if (feedAtHungerLevel == HungerLevel.ANY) {
            return true;
        }
        int nutrition = foodProperties.getNutrition();
        return (feedAtHungerLevel == HungerLevel.HALF ? nutrition / 2 : nutrition) <= hungerLevel;
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public HungerLevel getFeedAtHungerLevel() {
        return NBTHelper.getEnumConstant(this.upgrade, "feedAtHungerLevel", HungerLevel::fromName).orElse(HungerLevel.HALF);
    }

    public void setFeedAtHungerLevel(HungerLevel hungerLevel) {
        NBTHelper.setEnumConstant(this.upgrade, "feedAtHungerLevel", hungerLevel);
        this.save();
    }

    public boolean shouldFeedImmediatelyWhenHurt() {
        return NBTHelper.getBoolean(this.upgrade, "feedImmediatelyWhenHurt").orElse(true);
    }

    public void setFeedImmediatelyWhenHurt(boolean feedImmediatelyWhenHurt) {
        NBTHelper.setBoolean(this.upgrade, "feedImmediatelyWhenHurt", feedImmediatelyWhenHurt);
        this.save();
    }
}

