/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.RecordItem;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.StorageSoundHandler;

public class PlayDiscPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedcore", "play_disc");
    private final boolean blockStorage;
    private final UUID storageUuid;
    private final int musicDiscItemId;
    private int entityId;
    private BlockPos pos;

    public PlayDiscPacket(UUID storageUuid, int musicDiscItemId, BlockPos pos) {
        this.blockStorage = true;
        this.storageUuid = storageUuid;
        this.musicDiscItemId = musicDiscItemId;
        this.pos = pos;
    }

    public PlayDiscPacket(UUID storageUuid, int musicDiscItemId, int entityId) {
        this.blockStorage = false;
        this.storageUuid = storageUuid;
        this.musicDiscItemId = musicDiscItemId;
        this.entityId = entityId;
    }

    public static PlayDiscPacket read(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            return new PlayDiscPacket(buffer.readUUID(), buffer.readInt(), buffer.readBlockPos());
        }
        return new PlayDiscPacket(buffer.readUUID(), buffer.readInt(), buffer.readInt());
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(this::handlePacket);
    }

    private void handlePacket() {
        Item discItem = Item.byId((int)this.musicDiscItemId);
        if (!(discItem instanceof RecordItem)) {
            return;
        }
        SoundEvent soundEvent = ((RecordItem)discItem).getSound();
        if (this.blockStorage) {
            StorageSoundHandler.playStorageSound(soundEvent, this.storageUuid, this.pos);
        } else {
            StorageSoundHandler.playStorageSound(soundEvent, this.storageUuid, this.entityId);
        }
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.blockStorage);
        buffer.writeUUID(this.storageUuid);
        buffer.writeInt(this.musicDiscItemId);
        if (this.blockStorage) {
            buffer.writeBlockPos(this.pos);
        } else {
            buffer.writeInt(this.entityId);
        }
    }

    public ResourceLocation id() {
        return ID;
    }
}

