/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.ServerStorageSoundHandler;

public class SoundStopNotificationPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedcore", "sound_stop_notification");
    private final UUID storageUuid;

    public SoundStopNotificationPacket(UUID storageUuid) {
        this.storageUuid = storageUuid;
    }

    public SoundStopNotificationPacket(FriendlyByteBuf buffer) {
        this(buffer.readUUID());
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        ServerStorageSoundHandler.onSoundStopped(player.level(), this.storageUuid);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.storageUuid);
    }

    public ResourceLocation id() {
        return ID;
    }
}

