/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.SoundStopNotificationPacket;

public class StorageSoundHandler {
    private static final int SOUND_STOP_CHECK_INTERVAL = 10;
    private static final Map<UUID, SoundInstance> storageSounds = new ConcurrentHashMap<UUID, SoundInstance>();
    private static long lastPlaybackChecked = 0L;

    private StorageSoundHandler() {
    }

    public static void playStorageSound(UUID storageUuid, SoundInstance sound) {
        StorageSoundHandler.stopStorageSound(storageUuid);
        storageSounds.put(storageUuid, sound);
        Minecraft.getInstance().getSoundManager().play(sound);
    }

    public static void stopStorageSound(UUID storageUuid) {
        if (storageSounds.containsKey(storageUuid)) {
            Minecraft.getInstance().getSoundManager().stop(storageSounds.remove(storageUuid));
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new SoundStopNotificationPacket(storageUuid)});
        }
    }

    public static void tick(TickEvent.LevelTickEvent event) {
        if (!storageSounds.isEmpty() && lastPlaybackChecked < event.level.getGameTime() - 10L) {
            lastPlaybackChecked = event.level.getGameTime();
            storageSounds.entrySet().removeIf(entry -> {
                if (!Minecraft.getInstance().getSoundManager().isActive((SoundInstance)entry.getValue())) {
                    PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new SoundStopNotificationPacket((UUID)entry.getKey())});
                    return true;
                }
                return false;
            });
        }
    }

    public static void playStorageSound(SoundEvent soundEvent, UUID storageUuid, BlockPos pos) {
        StorageSoundHandler.playStorageSound(storageUuid, (SoundInstance)SimpleSoundInstance.forRecord((SoundEvent)soundEvent, (Vec3)Vec3.atCenterOf((Vec3i)pos)));
    }

    public static void playStorageSound(SoundEvent soundEvent, UUID storageUuid, int entityId) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        Entity entity = level.getEntity(entityId);
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        StorageSoundHandler.playStorageSound(storageUuid, (SoundInstance)new EntityBoundSoundInstance(soundEvent, SoundSource.RECORDS, 2.0f, 1.0f, entity, level.random.nextLong()));
    }

    public static void onWorldUnload(LevelEvent.Unload evt) {
        storageSounds.clear();
        lastPlaybackChecked = 0L;
    }
}

