/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.tank;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeWrapper;

public class TankClickPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedcore", "tank_click");
    private final int upgradeSlot;

    public TankClickPacket(int upgradeSlot) {
        this.upgradeSlot = upgradeSlot;
    }

    public TankClickPacket(FriendlyByteBuf buffer) {
        this(buffer.readInt());
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        AbstractContainerMenu abstractContainerMenu;
        ServerPlayer serverPlayer;
        block9: {
            block8: {
                if (!(player instanceof ServerPlayer)) break block8;
                serverPlayer = (ServerPlayer)player;
                abstractContainerMenu = player.containerMenu;
                if (abstractContainerMenu instanceof StorageContainerMenuBase) break block9;
            }
            return;
        }
        StorageContainerMenuBase storageContainerMenu = (StorageContainerMenuBase)abstractContainerMenu;
        AbstractContainerMenu containerMenu = player.containerMenu;
        UpgradeContainerBase<?, ?> upgradeContainer = storageContainerMenu.getUpgradeContainers().get(this.upgradeSlot);
        if (!(upgradeContainer instanceof TankUpgradeContainer)) {
            return;
        }
        TankUpgradeContainer tankContainer = (TankUpgradeContainer)upgradeContainer;
        ItemStack cursorStack = containerMenu.getCarried();
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)cursorStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return;
        }
        TankUpgradeWrapper tankWrapper = (TankUpgradeWrapper)tankContainer.getUpgradeWrapper();
        FluidStack tankContents = tankWrapper.getContents();
        if (tankContents.isEmpty()) {
            TankClickPacket.drainHandler(serverPlayer, containerMenu, fluidHandler, tankWrapper);
        } else if (!tankWrapper.fillHandler(fluidHandler, itemStackIn -> {
            containerMenu.setCarried(itemStackIn);
            PacketDistributor.PLAYER.with((Object)serverPlayer).send((Packet)new ClientboundContainerSetSlotPacket(-1, containerMenu.incrementStateId(), -1, containerMenu.getCarried()));
        })) {
            TankClickPacket.drainHandler(serverPlayer, containerMenu, fluidHandler, tankWrapper);
        }
    }

    private static void drainHandler(ServerPlayer player, AbstractContainerMenu containerMenu, IFluidHandlerItem fluidHandler, TankUpgradeWrapper tankWrapper) {
        tankWrapper.drainHandler(fluidHandler, itemStackIn -> {
            containerMenu.setCarried(itemStackIn);
            PacketDistributor.PLAYER.with((Object)player).send((Packet)new ClientboundContainerSetSlotPacket(-1, containerMenu.incrementStateId(), -1, containerMenu.getCarried()));
        });
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.upgradeSlot);
    }

    public ResourceLocation id() {
        return ID;
    }
}

