/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.tank;

import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeCountLimitConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeWrapper;

public class TankUpgradeItem
extends UpgradeItemBase<TankUpgradeWrapper> {
    public static final UpgradeType<TankUpgradeWrapper> TYPE = new UpgradeType<TankUpgradeWrapper>(TankUpgradeWrapper::new);
    public static final List<IUpgradeItem.UpgradeConflictDefinition> UPGRADE_CONFLICT_DEFINITIONS = List.of(new IUpgradeItem.UpgradeConflictDefinition(TankUpgradeItem.class::isInstance, 1, TranslationHelper.INSTANCE.translError("add.two_tank_upgrades_present", new Object[0])));
    private final TankUpgradeConfig tankUpgradeConfig;

    public TankUpgradeItem(TankUpgradeConfig tankUpgradeConfig, IUpgradeCountLimitConfig upgradeTypeLimitConfig) {
        super(upgradeTypeLimitConfig);
        this.tankUpgradeConfig = tankUpgradeConfig;
    }

    public int getBaseCapacity(IStorageWrapper storageWrapper) {
        return (Integer)this.tankUpgradeConfig.capacityPerSlotRow.get() * storageWrapper.getNumberOfSlotRows();
    }

    public int getAdjustedStackMultiplier(IStorageWrapper storageWrapper) {
        return 1 + (int)((Double)this.tankUpgradeConfig.stackMultiplierRatio.get() * (storageWrapper.getInventoryHandler().getStackSizeMultiplier() - 1.0));
    }

    public int getTankCapacity(IStorageWrapper storageWrapper) {
        int baseCapacity;
        int stackMultiplier = this.getAdjustedStackMultiplier(storageWrapper);
        return Integer.MAX_VALUE / stackMultiplier < (baseCapacity = this.getBaseCapacity(storageWrapper)) ? Integer.MAX_VALUE : baseCapacity * stackMultiplier;
    }

    public TankUpgradeConfig getTankUpgradeConfig() {
        return this.tankUpgradeConfig;
    }

    @Override
    public UpgradeType<TankUpgradeWrapper> getType() {
        return TYPE;
    }

    @Override
    public UpgradeSlotChangeResult checkExtraInsertConditions(ItemStack upgradeStack, IStorageWrapper storageWrapper, boolean isClientSide) {
        int multiplierRequired = (int)Math.ceil((float)TankUpgradeWrapper.getContents(upgradeStack).getAmount() / (float)this.getTankCapacity(storageWrapper));
        if (multiplierRequired > 1) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.INSTANCE.translError("add.tank_capacity_high", multiplierRequired), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        }
        return new UpgradeSlotChangeResult.Success();
    }

    @Override
    public List<IUpgradeItem.UpgradeConflictDefinition> getUpgradeConflicts() {
        return UPGRADE_CONFLICT_DEFINITIONS;
    }

    @Override
    public int getInventoryColumnsTaken() {
        return 2;
    }
}

