/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class ItemStackHelper {
    private ItemStackHelper() {
    }

    public static boolean areItemStackTagsEqualIgnoreDurability(ItemStack stackA, ItemStack stackB) {
        if (stackA.isEmpty() && stackB.isEmpty()) {
            return true;
        }
        if (!stackA.isEmpty() && !stackB.isEmpty()) {
            if (stackA.getTag() == null && stackB.getTag() != null) {
                return false;
            }
            return (stackA.getTag() == null || ItemStackHelper.areTagsEqualIgnoreDurability(stackA.getTag(), stackB.getTag())) && stackA.areAttachmentsCompatible(stackB);
        }
        return false;
    }

    public static boolean areTagsEqualIgnoreDurability(CompoundTag tagA, @Nullable CompoundTag tagB) {
        if (tagA == tagB) {
            return true;
        }
        if (tagB == null || tagA.size() != tagB.size()) {
            return false;
        }
        for (String key : tagA.getAllKeys()) {
            if (!tagB.contains(key)) {
                return false;
            }
            if (key.equals("Damage") || Objects.equals(tagA.get(key), tagB.get(key))) continue;
            return false;
        }
        return true;
    }
}

