/*
 * Decompiled with CFR 0.152.
 */
package fuzs.blockrunner.mixin;

import com.google.common.base.Objects;
import fuzs.blockrunner.world.level.block.data.BlockSpeedManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
abstract class LivingEntityMixin
extends Entity {
    @Shadow
    private BlockPos lastPos;

    public LivingEntityMixin(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Inject(method={"getBlockSpeedFactor"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getBlockSpeedFactor(CallbackInfoReturnable<Float> callback) {
        if (BlockSpeedManager.INSTANCE.hasBlockSpeed(this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock())) {
            callback.setReturnValue((Object)Float.valueOf(1.0f));
        }
    }

    @Inject(method={"onChangedBlock"}, at={@At(value="TAIL")})
    protected void onChangedBlock(BlockPos pos, CallbackInfo callback) {
        this.blockrunner$onChangedBlock();
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="HEAD")})
    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos, CallbackInfo callback) {
        if ((!this.level().isClientSide || LivingEntity.class.cast((Object)this) instanceof Player) && onGround && this.fallDistance > 0.0f) {
            this.blockrunner$removeBlockSpeed();
            this.blockrunner$tryAddBlockSpeed();
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    public void baseTick(CallbackInfo callback) {
        BlockPos blockPos;
        if (this.level().isClientSide && LivingEntity.class.cast((Object)this) instanceof Player && !Objects.equal((Object)this.lastPos, (Object)(blockPos = this.blockPosition()))) {
            this.lastPos = blockPos;
            this.blockrunner$onChangedBlock();
        }
    }

    @Unique
    private void blockrunner$onChangedBlock() {
        if (this.shouldRemoveSoulSpeed(this.getBlockStateOn())) {
            this.blockrunner$removeBlockSpeed();
        }
        this.blockrunner$tryAddBlockSpeed();
    }

    @Unique
    private void blockrunner$removeBlockSpeed() {
        AttributeInstance attribute = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (attribute != null && attribute.getModifier(BlockSpeedManager.SPEED_MODIFIER_BLOCK_SPEED_UUID) != null) {
            attribute.removeModifier(BlockSpeedManager.SPEED_MODIFIER_BLOCK_SPEED_UUID);
        }
    }

    @Unique
    protected void blockrunner$tryAddBlockSpeed() {
        block6: {
            BlockState blockStateOn;
            block5: {
                Object t = LivingEntity.class.cast((Object)this);
                if (!(t instanceof Player)) break block5;
                Player player = (Player)t;
                if (player.getAbilities().flying) break block6;
            }
            if (!(blockStateOn = this.getBlockStateOn()).isAir()) {
                double speedFactor = BlockSpeedManager.INSTANCE.getSpeedFactor(blockStateOn.getBlock());
                AttributeInstance attribute = this.getAttribute(Attributes.MOVEMENT_SPEED);
                if (attribute == null || speedFactor == 1.0) {
                    return;
                }
                double baseValue = attribute.getBaseValue();
                speedFactor = speedFactor * baseValue - baseValue;
                attribute.addTransientModifier(new AttributeModifier(BlockSpeedManager.SPEED_MODIFIER_BLOCK_SPEED_UUID, "Block speed boost", speedFactor, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    @Shadow
    public abstract AttributeInstance getAttribute(Attribute var1);

    @Shadow
    protected abstract boolean shouldRemoveSoulSpeed(BlockState var1);
}

