/*
 * Decompiled with CFR 0.152.
 */
package fuzs.blockrunner.network;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.blockrunner.world.level.block.data.BlockSpeedManager;
import fuzs.puzzleslib.api.config.v3.json.JsonConfigFileUtil;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.puzzleslib.api.network.v2.WritableMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class S2CBlockSpeedMessage
implements WritableMessage<S2CBlockSpeedMessage> {
    private final JsonObject customBlockSpeeds;

    public S2CBlockSpeedMessage(JsonObject customBlockSpeeds) {
        this.customBlockSpeeds = customBlockSpeeds;
    }

    public S2CBlockSpeedMessage(FriendlyByteBuf buf) {
        this.customBlockSpeeds = (JsonObject)JsonConfigFileUtil.GSON.fromJson(buf.readUtf(262144), JsonObject.class);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(JsonConfigFileUtil.GSON.toJson((JsonElement)this.customBlockSpeeds), 262144);
    }

    public MessageV2.MessageHandler<S2CBlockSpeedMessage> makeHandler() {
        return new MessageV2.MessageHandler<S2CBlockSpeedMessage>(){

            public void handle(S2CBlockSpeedMessage message, Player player, Object gameInstance) {
                BlockSpeedManager.INSTANCE.deserialize(message.customBlockSpeeds);
            }
        };
    }
}

