/*
 * Decompiled with CFR 0.152.
 */
package fuzs.blockrunner.world.level.block.data;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.blockrunner.BlockRunner;
import fuzs.blockrunner.init.ModRegistry;
import fuzs.blockrunner.network.S2CBlockSpeedMessage;
import fuzs.blockrunner.world.level.block.data.SpeedHolderValue;
import fuzs.puzzleslib.api.config.v3.json.JsonConfigFileUtil;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class BlockSpeedManager
implements ResourceManagerReloadListener {
    public static final BlockSpeedManager INSTANCE = new BlockSpeedManager();
    public static final String SCHEMA_VERSION = String.valueOf(2);
    public static final UUID SPEED_MODIFIER_BLOCK_SPEED_UUID = UUID.fromString("23237052-61AD-11EB-AE93-0242AC130002");
    private static final String CONFIG_FILE_NAME = "blockrunner.json";
    private static final Set<SpeedHolderValue> DEFAULT_BLOCK_SPEEDS = new SpeedHolderValue.Builder().add((TagKey<Block>)BlockTags.STONE_BRICKS, 1.15).add(Blocks.DIRT_PATH, 1.35).add(ModRegistry.VERY_SLOW_BLOCKS_BLOCK_TAG, 0.45).add(ModRegistry.SLOW_BLOCKS_BLOCK_TAG, 0.65).add(ModRegistry.SLIGHTLY_SLOW_BLOCKS_BLOCK_TAG, 0.85).add(ModRegistry.SLIGHTLY_QUICK_BLOCKS_BLOCK_TAG, 1.15).add(ModRegistry.QUICK_BLOCKS_BLOCK_TAG, 1.35).add(ModRegistry.VERY_QUICK_BLOCKS_BLOCK_TAG, 1.55).build();
    private final Set<SpeedHolderValue> blockSpeedValues = Sets.newHashSet();
    private Map<Block, Double> blockSpeeds;

    public void onSyncDataPackContents(ServerPlayer player, boolean joined) {
        BlockRunner.NETWORK.sendTo((MessageV2)new S2CBlockSpeedMessage(this.serialize(this.blockSpeedValues)), player);
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        JsonConfigFileUtil.getAndLoad((String)CONFIG_FILE_NAME, this::serialize, this::deserialize);
        if (ModLoaderEnvironment.INSTANCE.isServer() && CommonAbstractions.INSTANCE.getMinecraftServer() != null) {
            BlockRunner.NETWORK.sendToAll((MessageV2)new S2CBlockSpeedMessage(this.serialize(this.blockSpeedValues)));
        }
    }

    private void dissolve() {
        if (this.blockSpeeds == null) {
            HashMap blockSpeeds = Maps.newHashMap();
            try {
                for (SpeedHolderValue value : this.blockSpeedValues) {
                    value.addValues(blockSpeeds);
                }
            }
            catch (Exception e) {
                BlockRunner.LOGGER.error(e.getMessage());
                blockSpeeds.clear();
            }
            this.blockSpeeds = blockSpeeds;
        }
    }

    public boolean hasBlockSpeed(Block block) {
        this.dissolve();
        return this.blockSpeeds.containsKey(block);
    }

    public double getSpeedFactor(Block block) {
        this.dissolve();
        return this.blockSpeeds.getOrDefault(block, 1.0);
    }

    private void serialize(File jsonFile) {
        JsonConfigFileUtil.saveToFile((File)jsonFile, (JsonElement)this.serialize(DEFAULT_BLOCK_SPEEDS));
    }

    private JsonObject serialize(Set<SpeedHolderValue> values) {
        JsonObject jsonElements = new JsonObject();
        jsonElements.addProperty("schema_version", SCHEMA_VERSION);
        for (SpeedHolderValue value : values) {
            value.serialize(jsonElements);
        }
        return jsonElements;
    }

    private void deserialize(FileReader reader) {
        this.deserialize((JsonObject)JsonConfigFileUtil.GSON.fromJson((Reader)reader, JsonObject.class));
    }

    public void deserialize(JsonObject jsonObject) {
        this.blockSpeedValues.clear();
        this.blockSpeeds = null;
        IdentityHashMap blockSpeedValues = Maps.newIdentityHashMap();
        String schemaVersion = GsonHelper.getAsString((JsonObject)jsonObject, (String)"schema_version", (String)GsonHelper.getAsString((JsonObject)jsonObject, (String)"schemaVersion", (String)"1"));
        if (!schemaVersion.equals(SCHEMA_VERSION)) {
            BlockRunner.LOGGER.warn("Outdated config schema! Config might not work correctly. Current schema is {}.", (Object)SCHEMA_VERSION);
            blockSpeedValues.put(BlockTags.STONE_BRICKS, new SpeedHolderValue.TagValue((TagKey<Block>)BlockTags.STONE_BRICKS, 1.15));
            blockSpeedValues.put(Blocks.DIRT_PATH, new SpeedHolderValue.BlockValue(Blocks.DIRT_PATH, 1.35));
        }
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("schema_version") || key.equals("schemaVersion")) continue;
            double speedValue = ((JsonElement)entry.getValue()).getAsDouble();
            if (key.startsWith("#")) {
                TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation(key.substring(1)));
                blockSpeedValues.put(tag, new SpeedHolderValue.TagValue((TagKey<Block>)tag, speedValue));
                continue;
            }
            ResourceLocation resourcelocation = ResourceLocation.tryParse((String)key);
            if (resourcelocation != null && BuiltInRegistries.BLOCK.containsKey(resourcelocation)) {
                Block block = (Block)BuiltInRegistries.BLOCK.get(resourcelocation);
                blockSpeedValues.put(block, new SpeedHolderValue.BlockValue(block, speedValue));
                continue;
            }
            BlockRunner.LOGGER.warn("Unknown block type '{}', valid types are: {}", resourcelocation != null ? resourcelocation : key, (Object)Joiner.on((String)", ").join((Iterable)BuiltInRegistries.BLOCK.keySet()));
        }
        this.blockSpeedValues.addAll(blockSpeedValues.values());
    }
}

