/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology;

import fuzs.enderzoology.config.CommonConfig;
import fuzs.enderzoology.handler.HuntingBowHandler;
import fuzs.enderzoology.handler.MobHuntingHandler;
import fuzs.enderzoology.handler.SoulboundRespawnHandler;
import fuzs.enderzoology.init.ModRegistry;
import fuzs.enderzoology.world.entity.EntityAttributeProviders;
import fuzs.enderzoology.world.entity.SpawnPlacementRules;
import fuzs.enderzoology.world.entity.item.PrimedCharge;
import fuzs.enderzoology.world.entity.projectile.ThrownOwlEgg;
import fuzs.enderzoology.world.level.EnderExplosionHelper;
import fuzs.enderzoology.world.level.EnderExplosionType;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.biome.v1.MobSpawnSettingsContext;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import fuzs.puzzleslib.api.core.v1.context.CreativeModeTabContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesCreateContext;
import fuzs.puzzleslib.api.core.v1.context.FlammableBlocksContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.UseItemEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.ArrowLooseCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerCopyEvents;
import fuzs.puzzleslib.api.event.v1.level.ExplosionEvents;
import fuzs.puzzleslib.api.init.v3.PotionBrewingRegistry;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnderZoology
implements ModConstructor {
    public static final String MOD_ID = "enderzoology";
    public static final String MOD_NAME = "Ender Zoology";
    public static final Logger LOGGER = LogManager.getLogger((String)"Ender Zoology");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"enderzoology").common(CommonConfig.class);

    public void onConstructMod() {
        ModRegistry.touch();
        EnderZoology.registerHandlers();
    }

    private static void registerHandlers() {
        ExplosionEvents.DETONATE.register(EnderExplosionHelper::onExplosionDetonate);
        ArrowLooseCallback.EVENT.register(HuntingBowHandler::onArrowLoose);
        UseItemEvents.TICK.register(HuntingBowHandler::onUseItemTick);
        ServerEntityLevelEvents.LOAD.register(MobHuntingHandler::onLoad);
        PlayerCopyEvents.COPY.register(SoulboundRespawnHandler::onPlayerClone);
    }

    public void onCommonSetup() {
        EnderZoology.registerDispenseBehaviors();
        EnderZoology.registerBrewingRecipes();
    }

    private static void registerDispenseBehaviors() {
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModRegistry.OWL_EGG_ITEM.value()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile getProjectile(Level level, Position position, ItemStack stack) {
                return (Projectile)Util.make((Object)((Object)new ThrownOwlEgg(level, position.x(), position.y(), position.z())), thrownEgg -> thrownEgg.setItem(stack));
            }
        });
        EnderZoology.registerChargeBehavior((Block)ModRegistry.ENDER_CHARGE_BLOCK.value(), EnderExplosionType.ENDER);
        EnderZoology.registerChargeBehavior((Block)ModRegistry.CONFUSING_CHARGE_BLOCK.value(), EnderExplosionType.CONFUSION);
        EnderZoology.registerChargeBehavior((Block)ModRegistry.CONCUSSION_CHARGE_BLOCK.value(), EnderExplosionType.CONCUSSION);
    }

    private static void registerChargeBehavior(Block block, final EnderExplosionType enderExplosionType) {
        DispenserBlock.registerBehavior((ItemLike)block, (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            protected ItemStack execute(BlockSource blockSource, ItemStack stack) {
                ServerLevel level = blockSource.level();
                BlockPos blockpos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
                PrimedCharge primedtnt = new PrimedCharge((Level)level, (double)blockpos.getX() + 0.5, blockpos.getY(), (double)blockpos.getZ() + 0.5, null, enderExplosionType);
                level.addFreshEntity((Entity)primedtnt);
                level.playSound(null, primedtnt.getX(), primedtnt.getY(), primedtnt.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, GameEvent.ENTITY_PLACE, blockpos);
                stack.shrink(1);
                return stack;
            }
        });
    }

    private static void registerBrewingRecipes() {
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe(Potions.AWKWARD, (Item)ModRegistry.ENDER_FRAGMENT_ITEM.value(), (Potion)ModRegistry.DISPLACEMENT_POTION.value());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((Potion)ModRegistry.DISPLACEMENT_POTION.value(), Items.GLOWSTONE_DUST, (Potion)ModRegistry.STRONG_DISPLACEMENT_POTION.value());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe(Potions.AWKWARD, (Item)ModRegistry.WITHERING_DUST_ITEM.value(), (Potion)ModRegistry.DECAY_POTION.value());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((Potion)ModRegistry.DECAY_POTION.value(), Items.REDSTONE, (Potion)ModRegistry.LONG_DECAY_POTION.value());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((Potion)ModRegistry.DECAY_POTION.value(), Items.GLOWSTONE_DUST, (Potion)ModRegistry.STRONG_DECAY_POTION.value());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe(Potions.AWKWARD, (Item)ModRegistry.CONFUSING_POWDER_ITEM.value(), (Potion)ModRegistry.CONFUSION_POTION.value());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((Potion)ModRegistry.CONFUSION_POTION.value(), Items.REDSTONE, (Potion)ModRegistry.LONG_CONFUSION_POTION.value());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((Potion)ModRegistry.CONFUSION_POTION.value(), Items.GLOWSTONE_DUST, (Potion)ModRegistry.STRONG_CONFUSION_POTION.value());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe(Potions.AWKWARD, (Item)ModRegistry.OWL_EGG_ITEM.value(), (Potion)ModRegistry.RISING_POTION.value());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((Potion)ModRegistry.RISING_POTION.value(), Items.REDSTONE, (Potion)ModRegistry.LONG_RISING_POTION.value());
    }

    public void onRegisterFlammableBlocks(FlammableBlocksContext context) {
        context.registerFlammable(15, 100, new Block[]{(Block)ModRegistry.ENDER_CHARGE_BLOCK.value(), (Block)ModRegistry.CONFUSING_CHARGE_BLOCK.value(), (Block)ModRegistry.CONCUSSION_CHARGE_BLOCK.value()});
    }

    public void onEntityAttributeCreation(EntityAttributesCreateContext context) {
        context.registerEntityAttributes((EntityType)ModRegistry.CONCUSSION_CREEPER_ENTITY_TYPE.value(), EntityAttributeProviders.createConcussionCreeperAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.INFESTED_ZOMBIE_ENTITY_TYPE.value(), EntityAttributeProviders.createEnderInfestedZombieAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.ENDERMINY_ENTITY_TYPE.value(), EntityAttributeProviders.createEnderminyAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.DIRE_WOLF_ENTITY_TYPE.value(), EntityAttributeProviders.createDireWolfAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.FALLEN_MOUNT_ENTITY_TYPE.value(), EntityAttributeProviders.createFallenMountAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.WITHER_CAT_ENTITY_TYPE.value(), EntityAttributeProviders.createWitherCatAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.WITHER_WITCH_ENTITY_TYPE.value(), EntityAttributeProviders.createWitherWitchAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.OWL_ENTITY_TYPE.value(), EntityAttributeProviders.createOwlAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.FALLEN_KNIGHT_ENTITY_TYPE.value(), EntityAttributeProviders.createFallenKnightAttributes());
    }

    public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
        context.registerSpawnPlacement((EntityType)ModRegistry.CONCUSSION_CREEPER_ENTITY_TYPE.value(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkSurfaceSpawnRules);
        context.registerSpawnPlacement((EntityType)ModRegistry.INFESTED_ZOMBIE_ENTITY_TYPE.value(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkSurfaceSpawnRules);
        context.registerSpawnPlacement((EntityType)ModRegistry.ENDERMINY_ENTITY_TYPE.value(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkSurfaceSpawnRules);
        context.registerSpawnPlacement((EntityType)ModRegistry.DIRE_WOLF_ENTITY_TYPE.value(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkDireWolfSpawnRules);
        context.registerSpawnPlacement((EntityType)ModRegistry.FALLEN_MOUNT_ENTITY_TYPE.value(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkMonsterSpawnRules);
        context.registerSpawnPlacement((EntityType)ModRegistry.WITHER_CAT_ENTITY_TYPE.value(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkMonsterSpawnRules);
        context.registerSpawnPlacement((EntityType)ModRegistry.WITHER_WITCH_ENTITY_TYPE.value(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkSurfaceSpawnRules);
        context.registerSpawnPlacement((EntityType)ModRegistry.OWL_ENTITY_TYPE.value(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, SpawnPlacementRules::checkOwlSpawnRules);
        context.registerSpawnPlacement((EntityType)ModRegistry.FALLEN_KNIGHT_ENTITY_TYPE.value(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkSurfaceSpawnRules);
    }

    public void onRegisterBiomeModifications(BiomeModificationsContext context) {
        context.register(BiomeLoadingPhase.ADDITIONS, loadingContext -> loadingContext.canGenerateIn(LevelStem.OVERWORLD), modificationContext -> {
            MobSpawnSettingsContext settings = modificationContext.mobSpawnSettings();
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).concussionCreeper) {
                EnderZoology.registerSpawnData(settings, MobCategory.MONSTER, EntityType.CREEPER, data -> new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.CONCUSSION_CREEPER_ENTITY_TYPE.value(), Math.max(1, data.getWeight().asInt() / 4), data.minCount, data.maxCount));
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).infestedZombie) {
                EnderZoology.registerSpawnData(settings, MobCategory.MONSTER, EntityType.ZOMBIE, data -> new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.INFESTED_ZOMBIE_ENTITY_TYPE.value(), Math.max(1, data.getWeight().asInt() / 4), 1, data.maxCount));
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).fallenKnight) {
                EnderZoology.registerSpawnData(settings, MobCategory.MONSTER, EntityType.ZOMBIE, data -> new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.FALLEN_KNIGHT_ENTITY_TYPE.value(), Math.max(1, data.getWeight().asInt() / 4), 4, 6));
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).enderminy) {
                EnderZoology.registerSpawnData(settings, MobCategory.MONSTER, EntityType.ENDERMAN, data -> new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.ENDERMINY_ENTITY_TYPE.value(), data.getWeight().asInt() * 3, Math.min(data.maxCount, data.minCount * 4), data.maxCount));
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).direWolf && modificationContext.climateSettings().hasPrecipitation() && modificationContext.climateSettings().getTemperature() < 0.0f) {
                EnderZoology.findVanillaSpawnData(settings, MobCategory.CREATURE, EntityType.WOLF).ifPresent(data -> settings.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.DIRE_WOLF_ENTITY_TYPE.value(), Math.max(1, data.getWeight().asInt() / 4), 3, 8)));
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).witherWitch) {
                EnderZoology.registerSpawnData(settings, MobCategory.MONSTER, EntityType.WITCH, data -> new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.WITHER_WITCH_ENTITY_TYPE.value(), data.getWeight(), data.minCount, data.maxCount));
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).owl && modificationContext.climateSettings().hasPrecipitation()) {
                EnderZoology.findVanillaSpawnData(settings, MobCategory.CREATURE, EntityType.RABBIT).ifPresent(data -> settings.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.OWL_ENTITY_TYPE.value(), data.getWeight(), data.minCount, data.maxCount)));
            }
        });
    }

    private static void registerSpawnData(MobSpawnSettingsContext settings, MobCategory category, EntityType<?> vanillaEntityType, Function<MobSpawnSettings.SpawnerData, MobSpawnSettings.SpawnerData> factory) {
        EnderZoology.findVanillaSpawnData(settings, category, vanillaEntityType).ifPresent(data -> settings.addSpawn(category, (MobSpawnSettings.SpawnerData)factory.apply((MobSpawnSettings.SpawnerData)data)));
    }

    private static Optional<MobSpawnSettings.SpawnerData> findVanillaSpawnData(MobSpawnSettingsContext settings, MobCategory category, EntityType<?> entityType) {
        return settings.getSpawnerData(category).stream().filter(data -> data.type == entityType).findAny();
    }

    private static void registerSpawnCost(MobSpawnSettingsContext spawnSettings, EntityType<?> vanillaEntityType, EntityType<?> modEntityType, DoubleUnaryOperator chargeConverter, DoubleUnaryOperator energyBudgetConverter) {
        Optional<MobSpawnSettings.MobSpawnCost> optionalMobSpawnCost = Optional.ofNullable(spawnSettings.getSpawnCost(vanillaEntityType));
        optionalMobSpawnCost.ifPresent(cost -> spawnSettings.setSpawnCost(modEntityType, chargeConverter.applyAsDouble(cost.charge()), energyBudgetConverter.applyAsDouble(cost.energyBudget())));
    }

    public void onRegisterCreativeModeTabs(CreativeModeTabContext context) {
        context.registerCreativeModeTab(CreativeModeTabConfigurator.from((String)MOD_ID).icon(() -> new ItemStack((ItemLike)ModRegistry.ENDER_FRAGMENT_ITEM.value())).appendEnchantmentsAndPotions().displayItems((itemDisplayParameters, output) -> {
            output.accept((ItemLike)ModRegistry.ENDER_CHARGE_ITEM.value());
            output.accept((ItemLike)ModRegistry.CONFUSING_CHARGE_ITEM.value());
            output.accept((ItemLike)ModRegistry.CONCUSSION_CHARGE_ITEM.value());
            output.accept((ItemLike)ModRegistry.CONFUSING_POWDER_ITEM.value());
            output.accept((ItemLike)ModRegistry.ENDER_FRAGMENT_ITEM.value());
            output.accept((ItemLike)ModRegistry.HUNTING_BOW.value());
            output.accept((ItemLike)ModRegistry.OWL_EGG_ITEM.value());
            output.accept((ItemLike)ModRegistry.WITHERING_DUST_ITEM.value());
            output.accept((ItemLike)ModRegistry.ENDERIOS_ITEM.value());
            output.accept((ItemLike)ModRegistry.ENDER_CHARGE_MINECART_ITEM.value());
            output.accept((ItemLike)ModRegistry.CONFUSING_CHARGE_MINECART_ITEM.value());
            output.accept((ItemLike)ModRegistry.CONCUSSION_CHARGE_MINECART_ITEM.value());
            output.accept((ItemLike)ModRegistry.CONCUSSION_CREEPER_SPAWN_EGG_ITEM.value());
            output.accept((ItemLike)ModRegistry.INFESTED_ZOMBIE_SPAWN_EGG_ITEM.value());
            output.accept((ItemLike)ModRegistry.ENDERMINY_SPAWN_EGG_ITEM.value());
            output.accept((ItemLike)ModRegistry.DIRE_WOLF_SPAWN_EGG_ITEM.value());
            output.accept((ItemLike)ModRegistry.FALLEN_MOUNT_SPAWN_EGG_ITEM.value());
            output.accept((ItemLike)ModRegistry.WITHER_CAT_SPAWN_EGG_ITEM.value());
            output.accept((ItemLike)ModRegistry.WITHER_WITCH_SPAWN_EGG_ITEM.value());
            output.accept((ItemLike)ModRegistry.OWL_SPAWN_EGG_ITEM.value());
            output.accept((ItemLike)ModRegistry.FALLEN_KNIGHT_SPAWN_EGG_ITEM.value());
        }));
    }

    public ContentRegistrationFlags[] getContentRegistrationFlags() {
        return new ContentRegistrationFlags[]{ContentRegistrationFlags.BIOME_MODIFICATIONS};
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

