/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.client;

import fuzs.enderzoology.EnderZoology;
import fuzs.enderzoology.client.handler.FovModifierHandler;
import fuzs.enderzoology.client.init.ClientModRegistry;
import fuzs.enderzoology.client.model.OwlModel;
import fuzs.enderzoology.client.packs.DynamicallyCopiedPackResources;
import fuzs.enderzoology.client.renderer.entity.ConcussionCreeperRenderer;
import fuzs.enderzoology.client.renderer.entity.DireWolfRenderer;
import fuzs.enderzoology.client.renderer.entity.EnderInfestedZombieRenderer;
import fuzs.enderzoology.client.renderer.entity.EnderminyRenderer;
import fuzs.enderzoology.client.renderer.entity.FallenKnightRenderer;
import fuzs.enderzoology.client.renderer.entity.FallenMountRenderer;
import fuzs.enderzoology.client.renderer.entity.OwlRenderer;
import fuzs.enderzoology.client.renderer.entity.WitherCatRenderer;
import fuzs.enderzoology.client.renderer.entity.WitherWitchRenderer;
import fuzs.enderzoology.init.ModRegistry;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.EntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.EntitySpectatorShaderContext;
import fuzs.puzzleslib.api.client.core.v1.context.ItemModelPropertiesContext;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.client.event.v1.entity.player.ComputeFovModifierCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderHandCallback;
import fuzs.puzzleslib.api.core.v1.context.PackRepositorySourcesContext;
import fuzs.puzzleslib.api.resources.v1.PackResourcesHelper;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.OcelotModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.WitchModel;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.entity.TntMinecartRenderer;
import net.minecraft.client.renderer.entity.TntRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;

public class EnderZoologyClient
implements ClientModConstructor {
    public void onConstructMod() {
        EnderZoologyClient.registerHandlers();
    }

    private static void registerHandlers() {
        ComputeFovModifierCallback.EVENT.register(FovModifierHandler::onComputeFovModifier);
        RenderHandCallback.EVENT.register(FovModifierHandler::onRenderHand);
    }

    public void onRegisterEntityRenderers(EntityRenderersContext context) {
        context.registerEntityRenderer((EntityType)ModRegistry.OWL_EGG_ENTITY_TYPE.value(), ThrownItemRenderer::new);
        context.registerEntityRenderer((EntityType)ModRegistry.PRIMED_CHARGE_ENTITY_TYPE.value(), TntRenderer::new);
        context.registerEntityRenderer((EntityType)ModRegistry.CONCUSSION_CREEPER_ENTITY_TYPE.value(), ConcussionCreeperRenderer::new);
        context.registerEntityRenderer((EntityType)ModRegistry.INFESTED_ZOMBIE_ENTITY_TYPE.value(), EnderInfestedZombieRenderer::new);
        context.registerEntityRenderer((EntityType)ModRegistry.ENDERMINY_ENTITY_TYPE.value(), EnderminyRenderer::new);
        context.registerEntityRenderer((EntityType)ModRegistry.DIRE_WOLF_ENTITY_TYPE.value(), DireWolfRenderer::new);
        context.registerEntityRenderer((EntityType)ModRegistry.FALLEN_MOUNT_ENTITY_TYPE.value(), FallenMountRenderer::new);
        context.registerEntityRenderer((EntityType)ModRegistry.WITHER_CAT_ENTITY_TYPE.value(), WitherCatRenderer::new);
        context.registerEntityRenderer((EntityType)ModRegistry.WITHER_WITCH_ENTITY_TYPE.value(), WitherWitchRenderer::new);
        context.registerEntityRenderer((EntityType)ModRegistry.OWL_ENTITY_TYPE.value(), OwlRenderer::new);
        context.registerEntityRenderer((EntityType)ModRegistry.FALLEN_KNIGHT_ENTITY_TYPE.value(), FallenKnightRenderer::new);
        context.registerEntityRenderer((EntityType)ModRegistry.ENDER_CHARGE_MINECART_ENTITY_TYPE.value(), TntMinecartRenderer::new);
        context.registerEntityRenderer((EntityType)ModRegistry.CONFUSING_CHARGE_MINECART_ENTITY_TYPE.value(), TntMinecartRenderer::new);
        context.registerEntityRenderer((EntityType)ModRegistry.CONCUSSION_CHARGE_MINECART_ENTITY_TYPE.value(), TntMinecartRenderer::new);
    }

    public void onRegisterEntitySpectatorShaders(EntitySpectatorShaderContext context) {
        context.registerSpectatorShader(new ResourceLocation("shaders/post/creeper.json"), new EntityType[]{(EntityType)ModRegistry.CONCUSSION_CREEPER_ENTITY_TYPE.value()});
        context.registerSpectatorShader(new ResourceLocation("shaders/post/invert.json"), new EntityType[]{(EntityType)ModRegistry.ENDERMINY_ENTITY_TYPE.value()});
    }

    public void onRegisterItemModelProperties(ItemModelPropertiesContext context) {
        context.registerItemProperty(new ResourceLocation("pull"), (stack, level, entity, data) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.getUseItem() != stack ? 0.0f : (float)(stack.getUseDuration() - entity.getUseItemRemainingTicks()) / 20.0f;
        }, new ItemLike[]{(ItemLike)ModRegistry.HUNTING_BOW.value()});
        context.registerItemProperty(new ResourceLocation("pulling"), (stack, level, entity, data) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f, new ItemLike[]{(ItemLike)ModRegistry.HUNTING_BOW.value()});
    }

    public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
        context.registerLayerDefinition(ClientModRegistry.OWL, OwlModel::createBodyLayer);
        context.registerLayerDefinition(ClientModRegistry.FALLEN_KNIGHT, SkeletonModel::createBodyLayer);
        context.registerLayerDefinition(ClientModRegistry.FALLEN_KNIGHT_INNER_ARMOR, () -> LayerDefinition.create((MeshDefinition)HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.5f), (float)0.0f), (int)64, (int)32));
        context.registerLayerDefinition(ClientModRegistry.FALLEN_KNIGHT_OUTER_ARMOR, () -> LayerDefinition.create((MeshDefinition)HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f), (int)64, (int)32));
        context.registerLayerDefinition(ClientModRegistry.ENDER_INFESTED_ZOMBIE, () -> LayerDefinition.create((MeshDefinition)HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f), (int)64, (int)64));
        context.registerLayerDefinition(ClientModRegistry.ENDER_INFESTED_ZOMBIE_INNER_ARMOR, () -> LayerDefinition.create((MeshDefinition)HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.5f), (float)0.0f), (int)64, (int)32));
        context.registerLayerDefinition(ClientModRegistry.ENDER_INFESTED_ZOMBIE_OUTER_ARMOR, () -> LayerDefinition.create((MeshDefinition)HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f), (int)64, (int)32));
        context.registerLayerDefinition(ClientModRegistry.ENDERMINY, EndermanModel::createBodyLayer);
        context.registerLayerDefinition(ClientModRegistry.FALLEN_MOUNT, () -> LayerDefinition.create((MeshDefinition)HorseModel.createBodyMesh((CubeDeformation)CubeDeformation.NONE), (int)64, (int)64));
        context.registerLayerDefinition(ClientModRegistry.FALLEN_MOUNT_ARMOR, () -> LayerDefinition.create((MeshDefinition)HorseModel.createBodyMesh((CubeDeformation)new CubeDeformation(0.1f)), (int)64, (int)64));
        context.registerLayerDefinition(ClientModRegistry.WITHER_CAT, () -> LayerDefinition.create((MeshDefinition)OcelotModel.createBodyMesh((CubeDeformation)CubeDeformation.NONE), (int)64, (int)32));
        context.registerLayerDefinition(ClientModRegistry.WITHER_WITCH, WitchModel::createBodyLayer);
        context.registerLayerDefinition(ClientModRegistry.DIRE_WOLF, WolfModel::createBodyLayer);
        context.registerLayerDefinition(ClientModRegistry.CONCUSSION_CREEPER, () -> CreeperModel.createBodyLayer((CubeDeformation)CubeDeformation.NONE));
        context.registerLayerDefinition(ClientModRegistry.CONCUSSION_CREEPER_ARMOR, () -> CreeperModel.createBodyLayer((CubeDeformation)new CubeDeformation(2.0f)));
    }

    public void onAddResourcePackFinders(PackRepositorySourcesContext context) {
        context.addRepositorySource(new RepositorySource[]{PackResourcesHelper.buildClientPack((ResourceLocation)EnderZoology.id("dynamically_copied_textures"), DynamicallyCopiedPackResources.create(new DynamicallyCopiedPackResources.TextureCopy(FallenMountRenderer.VANILLA_TEXTURE_LOCATION, FallenMountRenderer.TEXTURE_LOCATION, 64, 64)), (boolean)false)});
    }
}

