/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.enderzoology.client.init.ClientModRegistry;
import fuzs.enderzoology.world.entity.monster.FallenMount;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.DyeableHorseArmorItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FallenMountArmorLayer
extends RenderLayer<FallenMount, HorseModel<FallenMount>> {
    private final HorseModel<FallenMount> model;

    public FallenMountArmorLayer(RenderLayerParent<FallenMount, HorseModel<FallenMount>> renderLayerParent, EntityModelSet entityModelSet) {
        super(renderLayerParent);
        this.model = new HorseModel(entityModelSet.bakeLayer(ClientModRegistry.FALLEN_MOUNT_ARMOR));
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, FallenMount livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemStack = livingEntity.getArmor();
        Item item = itemStack.getItem();
        if (item instanceof HorseArmorItem) {
            float h;
            float g;
            float f;
            HorseArmorItem item2 = (HorseArmorItem)item;
            ((HorseModel)this.getParentModel()).copyPropertiesTo(this.model);
            this.model.prepareMobModel((AbstractHorse)livingEntity, limbSwing, limbSwingAmount, partialTicks);
            this.model.setupAnim((AbstractHorse)livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            if (item2 instanceof DyeableHorseArmorItem) {
                int i = ((DyeableHorseArmorItem)item2).getColor(itemStack);
                f = (float)(i >> 16 & 0xFF) / 255.0f;
                g = (float)(i >> 8 & 0xFF) / 255.0f;
                h = (float)(i & 0xFF) / 255.0f;
            } else {
                f = 1.0f;
                g = 1.0f;
                h = 1.0f;
            }
            VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)item2.getTexture()));
            this.model.renderToBuffer(matrixStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, f, g, h, 1.0f);
        }
    }
}

