/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.handler;

import fuzs.enderzoology.init.ModRegistry;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class HuntingBowHandler {
    private static final float BOW_MULTISHOT_ANGLE = 6.5f;

    public static EventResult onArrowLoose(Player player, ItemStack stack, Level level, MutableInt charge, boolean hasAmmo) {
        if (hasAmmo && EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.MULTISHOT, (ItemStack)stack) > 0) {
            float velocity = BowItem.getPowerForTime((int)charge.getAsInt());
            if (!level.isClientSide && velocity >= 0.1f) {
                ItemStack projectile = player.getProjectile(stack);
                ArrowItem item = (ArrowItem)(projectile.getItem() instanceof ArrowItem ? projectile.getItem() : Items.ARROW);
                for (int i = 0; i < 2; ++i) {
                    HuntingBowHandler.createAndShootArrow(player, stack, level, item, projectile, -6.5f + (float)i * 6.5f * 2.0f, velocity);
                }
            }
        }
        return EventResult.PASS;
    }

    private static void createAndShootArrow(Player player, ItemStack stack, Level level, ArrowItem item, ItemStack projectile, float shootAngle, float velocity) {
        AbstractArrow abstractArrow = item.createArrow(level, projectile, (LivingEntity)player);
        abstractArrow.shootFromRotation((Entity)player, player.getXRot() + shootAngle, player.getYRot(), 0.0f, velocity * 3.0f, 1.5f);
        if (velocity == 1.0f) {
            abstractArrow.setCritArrow(true);
        }
        HuntingBowHandler.applyPowerEnchantment(abstractArrow, stack);
        HuntingBowHandler.applyPunchEnchantment(abstractArrow, stack);
        HuntingBowHandler.applyFlameEnchantment(abstractArrow, stack);
        HuntingBowHandler.applyPiercingEnchantment(abstractArrow, stack);
        HuntingBowHandler.applyWitheringEnchantment(abstractArrow, stack);
        abstractArrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        level.addFreshEntity((Entity)abstractArrow);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + velocity * 0.5f);
    }

    public static EventResult onUseItemTick(LivingEntity entity, ItemStack useItem, MutableInt useItemRemaining) {
        if (useItem.getItem() instanceof BowItem && useItem.getUseDuration() - useItemRemaining.getAsInt() < 20) {
            int quickChargeLevel = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.QUICK_CHARGE, (ItemStack)useItem);
            useItemRemaining.mapInt(duration -> duration - quickChargeLevel);
        }
        return EventResult.PASS;
    }

    public static void applyPowerEnchantment(AbstractArrow arrow, ItemStack stack) {
        int level = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.POWER_ARROWS, (ItemStack)stack);
        if (level > 0) {
            arrow.setBaseDamage(arrow.getBaseDamage() + (double)level * 0.5 + 0.5);
        }
    }

    public static void applyPunchEnchantment(AbstractArrow arrow, ItemStack stack) {
        int level = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.PUNCH_ARROWS, (ItemStack)stack);
        if (level > 0) {
            arrow.setKnockback(level);
        }
    }

    public static void applyFlameEnchantment(AbstractArrow arrow, ItemStack stack) {
        if (EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.FLAMING_ARROWS, (ItemStack)stack) > 0) {
            arrow.setSecondsOnFire(100);
        }
    }

    public static void applyPiercingEnchantment(AbstractArrow arrow, ItemStack stack) {
        int level = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.PIERCING, (ItemStack)stack);
        if (level > 0) {
            arrow.setPierceLevel((byte)level);
        }
    }

    public static void applyWitheringEnchantment(AbstractArrow arrow, ItemStack stack) {
        HuntingBowHandler.applyWitheringEnchantment(arrow, EnchantmentHelper.getItemEnchantmentLevel((Enchantment)((Enchantment)ModRegistry.WITHERING_ENCHANTMENT.value()), (ItemStack)stack));
    }

    public static void applyWitheringEnchantment(AbstractArrow arrow, LivingEntity shooter) {
        HuntingBowHandler.applyWitheringEnchantment(arrow, EnchantmentHelper.getEnchantmentLevel((Enchantment)((Enchantment)ModRegistry.WITHERING_ENCHANTMENT.value()), (LivingEntity)shooter));
    }

    private static void applyWitheringEnchantment(AbstractArrow arrow, int level) {
        if (level > 0 && arrow instanceof Arrow) {
            ((Arrow)arrow).addEffect(new MobEffectInstance(MobEffects.WITHER, 100 * level));
        }
    }
}

