/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.ai.goal;

import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;

public class RangedBowEasyAttackGoal<T extends Monster>
extends RangedBowAttackGoal<T> {
    private final T mob;
    private final double speedModifier;
    private int attackIntervalMin;
    private final int maxAttackTime;
    private final float attackRadiusSqr;
    private int attackTime = -1;
    private int seeTime;

    public RangedBowEasyAttackGoal(T mob, double speedModifier, int attackIntervalMin, int maxAttackTime, float attackRadius) {
        super(mob, speedModifier, attackIntervalMin, attackRadius);
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.attackIntervalMin = attackIntervalMin;
        this.maxAttackTime = maxAttackTime;
        this.attackRadiusSqr = attackRadius * attackRadius;
    }

    public void setMinAttackInterval(int attackCooldownIn) {
        this.attackIntervalMin = attackCooldownIn;
    }

    protected boolean isHoldingBow() {
        return this.mob.isHolding(stack -> stack.getItem() instanceof BowItem);
    }

    public void stop() {
        this.mob.setAggressive(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.stopUsingItem();
    }

    public void tick() {
        LivingEntity attackTarget = this.mob.getTarget();
        if (attackTarget != null) {
            double distanceToTarget = this.mob.distanceToSqr(attackTarget.getX(), attackTarget.getY(), attackTarget.getZ());
            boolean canSeeTarget = this.mob.getSensing().hasLineOfSight((Entity)attackTarget);
            if (canSeeTarget != this.seeTime > 0) {
                this.seeTime = 0;
            }
            this.seeTime = canSeeTarget ? ++this.seeTime : --this.seeTime;
            boolean moveTowardsTarget = false;
            if (distanceToTarget <= (double)this.attackRadiusSqr && this.seeTime >= 20) {
                this.mob.getNavigation().stop();
                moveTowardsTarget = distanceToTarget > (double)(this.attackRadiusSqr * 0.75f);
            } else {
                this.mob.getNavigation().moveTo((Entity)attackTarget, this.speedModifier);
            }
            if (moveTowardsTarget) {
                this.mob.getMoveControl().strafe(0.5f, 0.0f);
                this.mob.lookAt((Entity)attackTarget, 30.0f, 30.0f);
            } else {
                this.mob.getLookControl().setLookAt((Entity)attackTarget, 30.0f, 30.0f);
            }
            if (this.mob.isUsingItem()) {
                int useCount;
                if (!canSeeTarget && this.seeTime < -this.maxAttackTime) {
                    this.mob.stopUsingItem();
                } else if (canSeeTarget && (useCount = this.mob.getTicksUsingItem()) >= 20) {
                    this.mob.stopUsingItem();
                    double distanceVelocity = Math.sqrt(distanceToTarget) / Math.sqrt(this.attackRadiusSqr);
                    ((RangedAttackMob)this.mob).performRangedAttack(attackTarget, Mth.clamp((float)((float)distanceVelocity), (float)0.1f, (float)1.0f) * BowItem.getPowerForTime((int)useCount));
                    this.attackTime = Mth.floor((double)(distanceVelocity * (double)((float)this.maxAttackTime - (float)this.attackIntervalMin / 2.0f) + (double)((float)this.attackIntervalMin / 2.0f)));
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -this.maxAttackTime) {
                this.mob.startUsingItem(RangedBowEasyAttackGoal.getWeaponHoldingHand(this.mob, stack -> stack.getItem() instanceof BowItem));
            }
        }
    }

    public static InteractionHand getWeaponHoldingHand(LivingEntity entity, Predicate<ItemStack> filter) {
        return filter.test(entity.getMainHandItem()) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }
}

