/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import fuzs.enderzoology.mixin.accessor.CreeperAccessor;
import fuzs.enderzoology.world.entity.monster.Enderminy;
import fuzs.enderzoology.world.level.EnderExplosionHelper;
import fuzs.enderzoology.world.level.EnderExplosionType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class ConcussionCreeper
extends Creeper {
    public ConcussionCreeper(EntityType<? extends ConcussionCreeper> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.getAvailableGoals().stream().map(WrappedGoal::getGoal).filter(goal -> goal instanceof AvoidEntityGoal).limit(2L).toList().forEach(arg_0 -> ((GoalSelector)this.goalSelector).removeGoal(arg_0));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Enderminy.class, 6.0f, 1.0, 1.2));
    }

    protected void dropCustomDeathLoot(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
            boolean flag;
            ItemStack itemstack = this.getItemBySlot(equipmentslot);
            float f = this.getEquipmentDropChance(equipmentslot);
            boolean bl = flag = f > 1.0f;
            if (itemstack.isEmpty() || EnchantmentHelper.hasVanishingCurse((ItemStack)itemstack) || !pRecentlyHit && !flag || !(Math.max(this.random.nextFloat() - (float)pLooting * 0.01f, 0.0f) < f)) continue;
            if (!flag && itemstack.isDamageableItem()) {
                itemstack.setDamageValue(itemstack.getMaxDamage() - this.random.nextInt(1 + this.random.nextInt(Math.max(itemstack.getMaxDamage() - 3, 1))));
            }
            this.spawnAtLocation(itemstack);
            this.setItemSlot(equipmentslot, ItemStack.EMPTY);
        }
    }

    public void aiStep() {
        if (this.level().isClientSide) {
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getRandomX(0.5), this.getRandomY() - 0.25, this.getRandomZ(0.5), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
            }
        }
        super.aiStep();
    }

    public void tick() {
        if (this.isAlive() && ((CreeperAccessor)((Object)this)).enderzoology$getSwell() >= ((CreeperAccessor)((Object)this)).enderzoology$getMaxSwell() - 1) {
            ((CreeperAccessor)((Object)this)).enderzoology$setSwell(0);
            this.explodeCreeper();
        }
        super.tick();
    }

    private void explodeCreeper() {
        if (!this.level().isClientSide) {
            float poweredMultiplier = this.isPowered() ? 2.0f : 1.0f;
            float explosionRadius = (float)((CreeperAccessor)((Object)this)).enderzoology$getExplosionRadius() * poweredMultiplier;
            EnderExplosionHelper.explode(this.level(), (Entity)this, null, this.getX(), this.getY(), this.getZ(), explosionRadius, Level.ExplosionInteraction.MOB, EnderExplosionType.CONCUSSION, false);
            this.discard();
        }
    }
}

