/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import fuzs.enderzoology.core.CommonAbstractions;
import fuzs.enderzoology.init.ModRegistry;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FallenMount
extends AbstractHorse
implements Enemy {
    public static final String TAG_HORSE_DATA = "HorseData";
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("870A1AC8-9BD8-11ED-A8FC-0242AC120002");
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING_ID = SynchedEntityData.defineId(FallenMount.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Nullable
    private CompoundTag horseData;
    private int conversionTime;

    public FallenMount(EntityType<? extends AbstractHorse> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 5;
    }

    protected static String getEncodeId(Entity entity) {
        EntityType entityType = entity.getType();
        ResourceLocation resourceLocation = EntityType.getKey((EntityType)entityType);
        return entityType.canSerialize() && resourceLocation != null ? resourceLocation.toString() : null;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new MountRestrictSunGoal((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new MountFleeSunGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2f, false){

            public boolean canUse() {
                return !this.mob.isVehicle() && super.canUse();
            }
        });
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractHorse.class, false, entity -> entity.getType().is(ModRegistry.FALLEN_MOUNT_TARGETS_ENTITY_TYPE_TAG)));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public int getExperienceReward() {
        return this.xpReward;
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_CONVERTING_ID, (Object)false);
    }

    protected void randomizeAttributes(RandomSource randomSource) {
        this.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(FallenMount.generateJumpStrength(() -> ((RandomSource)randomSource).nextDouble()));
    }

    public void tick() {
        if (!this.level().isClientSide && this.isAlive() && this.isConverting()) {
            --this.conversionTime;
            if (this.conversionTime <= 0) {
                this.finishConversion();
            }
        }
        super.tick();
    }

    public boolean canEatGrass() {
        return false;
    }

    public boolean isSaddleable() {
        return false;
    }

    public void positionRider(Entity passenger, Entity.MoveFunction callback) {
        super.positionRider(passenger, callback);
        if (passenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)passenger;
            living.yBodyRot = this.yBodyRot;
            living.yHeadRot = this.yHeadRot;
            living.setYRot(this.getYRot());
            living.setXRot(this.getXRot());
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        return null;
    }

    public boolean isPushable() {
        return this.isAlive() && !this.isSpectator() && !this.onClimbable();
    }

    public boolean isImmobile() {
        return this.isDeadOrDying();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.GOLDEN_APPLE)) {
            if (this.hasEffect(MobEffects.WEAKNESS)) {
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
                if (!this.level().isClientSide) {
                    this.startConverting(this.random.nextInt(2400) + 3600);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(player, hand);
    }

    protected void doPlayerRide(Player player) {
    }

    public void aiStep() {
        if (this.isAlive() && this.isSunBurnTick() && !this.isVehicle() && !this.isWearingArmor()) {
            this.setSecondsOnFire(8);
        }
        super.aiStep();
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        float selector = random.nextFloat();
        Item item = selector < 0.015f ? Items.DIAMOND_HORSE_ARMOR : (selector < 0.05f ? Items.GOLDEN_HORSE_ARMOR : (selector < 0.2f ? Items.LEATHER_HORSE_ARMOR : Items.IRON_HORSE_ARMOR));
        this.setArmor(new ItemStack((ItemLike)item));
    }

    public boolean isSaddled() {
        return true;
    }

    public boolean canWearArmor() {
        return true;
    }

    public boolean isArmor(ItemStack stack) {
        return stack.getItem() instanceof HorseArmorItem;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.horseData != null) {
            tag.put(TAG_HORSE_DATA, (Tag)this.horseData);
        }
        if (!this.inventory.getItem(1).isEmpty()) {
            tag.put("ArmorItem", (Tag)this.inventory.getItem(1).save(new CompoundTag()));
        }
    }

    public ItemStack getArmor() {
        return this.getItemBySlot(EquipmentSlot.CHEST);
    }

    private void setArmor(ItemStack pStack) {
        this.setItemSlot(EquipmentSlot.CHEST, pStack);
        this.setDropChance(EquipmentSlot.CHEST, 0.0f);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        ItemStack itemstack;
        super.readAdditionalSaveData(tag);
        this.horseData = tag.getCompound(TAG_HORSE_DATA);
        if (tag.contains("ArmorItem", 10) && !(itemstack = ItemStack.of((CompoundTag)tag.getCompound("ArmorItem"))).isEmpty() && this.isArmor(itemstack)) {
            this.inventory.setItem(1, itemstack);
        }
        this.updateContainerEquipment();
    }

    protected void updateContainerEquipment() {
        if (!this.level().isClientSide) {
            super.updateContainerEquipment();
            this.setArmorEquipment(this.inventory.getItem(1));
            this.setDropChance(EquipmentSlot.CHEST, 0.0f);
        }
    }

    private void setArmorEquipment(ItemStack stack) {
        this.setArmor(stack);
        if (!this.level().isClientSide) {
            int i;
            this.getAttribute(Attributes.ARMOR).removeModifier(ARMOR_MODIFIER_UUID);
            if (this.isArmor(stack) && (i = ((HorseArmorItem)stack.getItem()).getProtection()) != 0) {
                this.getAttribute(Attributes.ARMOR).addTransientModifier(new AttributeModifier(ARMOR_MODIFIER_UUID, "Horse armor bonus", (double)i, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.isConverting() && (this.horseData == null || !this.horseData.getBoolean("Tame"));
    }

    public boolean isConverting() {
        return (Boolean)this.getEntityData().get(DATA_CONVERTING_ID);
    }

    private void startConverting(int villagerConversionTime) {
        this.conversionTime = villagerConversionTime;
        this.getEntityData().set(DATA_CONVERTING_ID, (Object)true);
        this.removeEffect(MobEffects.WEAKNESS);
        this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, villagerConversionTime, Math.min(this.level().getDifficulty().getId() - 1, 0)));
        this.level().broadcastEntityEvent((Entity)this, (byte)16);
    }

    public void handleEntityEvent(byte id) {
        if (id == 16) {
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getEyeY(), this.getZ(), SoundEvents.ZOMBIE_VILLAGER_CURE, this.getSoundSource(), 1.0f + this.random.nextFloat(), this.random.nextFloat() * 0.7f + 0.3f, false);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    private void finishConversion() {
        this.recreateHorseFromData(this.level(), this).or(this::createFreshHorse).ifPresent(entity -> {
            entity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
            if (!this.isSilent()) {
                this.level().levelEvent(null, 1027, this.blockPosition(), 0);
            }
            CommonAbstractions.INSTANCE.onLivingConvert((Mob)this, (Mob)entity);
        });
    }

    private Optional<AbstractHorse> recreateHorseFromData(Level level, FallenMount source) {
        CompoundTag tag = source.horseData;
        if (!level.isClientSide && tag != null && !tag.isEmpty()) {
            return EntityType.create((CompoundTag)tag, (Level)level).map(entity -> {
                AbstractHorse horse = (AbstractHorse)entity;
                horse.copyPosition((Entity)source);
                source.discard();
                level.addFreshEntity((Entity)horse);
                return horse;
            });
        }
        return Optional.empty();
    }

    private Optional<AbstractHorse> createFreshHorse() {
        EntityType entityType = this.random.nextInt(6) == 0 ? EntityType.DONKEY : EntityType.HORSE;
        AbstractHorse horse = (AbstractHorse)this.convertTo(entityType, false);
        for (int i = 0; i < EquipmentSlot.values().length; ++i) {
            EquipmentSlot equipmentSlot = EquipmentSlot.values()[i];
            ItemStack itemStack = this.getItemBySlot(equipmentSlot);
            if (itemStack.isEmpty()) continue;
            if (EnchantmentHelper.hasBindingCurse((ItemStack)itemStack)) {
                horse.getSlot(equipmentSlot.getIndex() + 300).set(itemStack);
                continue;
            }
            double d = this.getEquipmentDropChance(equipmentSlot);
            if (!(d > 1.0)) continue;
            this.spawnAtLocation(itemStack);
        }
        horse.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(horse.blockPosition()), MobSpawnType.CONVERSION, (SpawnGroupData)new AgeableMob.AgeableMobGroupData(0.0f), null);
        horse.setTamed(true);
        horse.setBaby(false);
        return Optional.of(horse);
    }

    public boolean killedEntity(ServerLevel level, LivingEntity entity) {
        boolean flag = super.killedEntity(level, entity);
        if ((level.getDifficulty() == Difficulty.NORMAL || level.getDifficulty() == Difficulty.HARD) && entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            if (CommonAbstractions.INSTANCE.canLivingConvert(entity, (EntityType<? extends LivingEntity>)((EntityType)ModRegistry.FALLEN_MOUNT_ENTITY_TYPE.value()), timer -> {})) {
                if (level.getDifficulty() != Difficulty.HARD && this.random.nextBoolean()) {
                    return flag;
                }
                FallenMount fallenMount = (FallenMount)horse.convertTo((EntityType)ModRegistry.FALLEN_MOUNT_ENTITY_TYPE.value(), true);
                fallenMount.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(fallenMount.blockPosition()), MobSpawnType.CONVERSION, (SpawnGroupData)new AgeableMob.AgeableMobGroupData(0.0f), null);
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.putString("id", FallenMount.getEncodeId((Entity)horse));
                horse.setHealth(horse.getMaxHealth());
                horse.setDeltaMovement(Vec3.ZERO);
                horse.saveWithoutId(compoundtag);
                fallenMount.horseData = compoundtag;
                CommonAbstractions.INSTANCE.onLivingConvert((Mob)horse, (Mob)fallenMount);
                if (!this.isSilent()) {
                    level.levelEvent(null, 1026, this.blockPosition(), 0);
                }
                flag = false;
            }
        }
        return flag;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        SpawnGroupData spawnGroupData = super.finalizeSpawn(level, difficulty, reason, spawnData, dataTag);
        this.populateDefaultEquipmentSlots(level.getRandom(), difficulty);
        return spawnGroupData;
    }

    public MobType getMobType() {
        return MobType.UNDEAD;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ZOMBIE_HORSE_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ZOMBIE_HORSE_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.ZOMBIE_HORSE_HURT;
    }

    protected void playSwimSound(float volume) {
        if (this.onGround()) {
            super.playSwimSound(0.3f);
        } else {
            super.playSwimSound(Math.min(0.1f, volume * 25.0f));
        }
    }

    protected float getWaterSlowDown() {
        return 0.96f;
    }

    static class MountRestrictSunGoal
    extends RestrictSunGoal {
        private final PathfinderMob mob;

        public MountRestrictSunGoal(PathfinderMob pathfinderMob) {
            super(pathfinderMob);
            this.mob = pathfinderMob;
        }

        public boolean canUse() {
            return !this.mob.isVehicle() && super.canUse();
        }
    }

    static class MountFleeSunGoal
    extends FleeSunGoal {
        public MountFleeSunGoal(PathfinderMob pathfinderMob, double d) {
            super(pathfinderMob, d);
        }

        public boolean canUse() {
            return !this.mob.isVehicle() && super.canUse();
        }
    }
}

