/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import fuzs.enderzoology.init.ModRegistry;
import fuzs.enderzoology.mixin.accessor.WitchAccessor;
import fuzs.enderzoology.world.entity.monster.CompanionMob;
import fuzs.enderzoology.world.entity.monster.WitherCat;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.goal.target.NearestHealableRaiderTargetGoal;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WitherWitch
extends Witch
implements CompanionMob<WitherCat> {
    private NearestHealableRaiderTargetGoal<WitherCat> healCatsGoal;
    private int ticksUntilNextAlert;

    public WitherWitch(EntityType<? extends WitherWitch> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.healCatsGoal = new NearestHealableRaiderTargetGoal<WitherCat>((Raider)this, WitherCat.class, true, mob -> mob.getHealth() < mob.getMaxHealth()){

            public boolean canUse() {
                if (this.getCooldown() <= 0 && this.mob.getRandom().nextBoolean()) {
                    this.findTarget();
                    if (this.target != null) {
                        if (this.target.level().getNearestPlayer(this.target.getX(), this.target.getY(), this.target.getZ(), 12.0, true) != null) {
                            this.target = null;
                            return false;
                        }
                        return true;
                    }
                }
                return false;
            }
        };
        this.targetSelector.addGoal(2, this.healCatsGoal);
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && this.isAlive()) {
            this.healCatsGoal.decrementCooldown();
            ((WitchAccessor)((Object)this)).enderzoology$getAttackPlayersGoal().setCanAttack(((WitchAccessor)((Object)this)).enderzoology$getHealRaidersGoal().getCooldown() <= 0 || this.healCatsGoal.getCooldown() <= 0);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        if (level instanceof ServerLevel && reason == MobSpawnType.NATURAL) {
            this.trySpawnCompanion((ServerLevel)level, this.blockPosition(), 4);
            if (this.random.nextInt(4) == 0) {
                this.trySpawnCompanion((ServerLevel)level, this.blockPosition(), 4);
            }
        }
        return super.finalizeSpawn(level, difficulty, reason, spawnData, dataTag);
    }

    private void trySpawnCompanion(ServerLevel serverLevel, BlockPos pos, int maxDistance) {
        BlockPos blockPos = this.findSpawnPositionNear(serverLevel, pos, maxDistance);
        if (blockPos != null) {
            ((EntityType)ModRegistry.WITHER_CAT_ENTITY_TYPE.value()).spawn(serverLevel, blockPos, MobSpawnType.EVENT);
        }
    }

    @Override
    public Mob getCompanionMob() {
        return this;
    }

    @Override
    public int getTicksUntilNextAlert() {
        return this.ticksUntilNextAlert;
    }

    @Override
    public void setTicksUntilNextAlert(int ticksUntilNextAlert) {
        this.ticksUntilNextAlert = ticksUntilNextAlert;
    }

    @Override
    public Class<WitherCat> getCompanionType() {
        return WitherCat.class;
    }

    @Nullable
    private BlockPos findSpawnPositionNear(ServerLevel level, BlockPos pos, int maxDistance) {
        BlockPos blockPos = null;
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = pos.getX() + this.random.nextInt(maxDistance * 2) - maxDistance;
            BlockPos blockPos2 = new BlockPos(j, l = level.getHeight(Heightmap.Types.WORLD_SURFACE, j, k = pos.getZ() + this.random.nextInt(maxDistance * 2) - maxDistance), k);
            if (!NaturalSpawner.isSpawnPositionOk((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)level, (BlockPos)blockPos2, (EntityType)((EntityType)ModRegistry.WITHER_WITCH_ENTITY_TYPE.value()))) continue;
            blockPos = blockPos2;
            break;
        }
        return blockPos;
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        if (!this.isDrinkingPotion()) {
            Potion potion;
            Vec3 vec3 = target.getDeltaMovement();
            double d = target.getX() + vec3.x - this.getX();
            double e = target.getEyeY() - 1.1 - this.getY();
            double f = target.getZ() + vec3.z - this.getZ();
            double g = Math.sqrt(d * d + f * f);
            Potion potion2 = potion = target.isInvertedHealAndHarm() ? Potions.HEALING : Potions.HARMING;
            if (target instanceof Raider || target instanceof WitherCat) {
                potion = this.random.nextInt(4) != 0 || target.getHealth() <= 4.0f ? Potions.HEALING : Potions.REGENERATION;
                this.setTarget(null);
            } else if (target.getHealth() >= 8.0f && !target.hasEffect(MobEffects.WITHER)) {
                potion = (Potion)ModRegistry.DECAY_POTION.value();
            } else if (g <= 3.0 && !target.hasEffect(MobEffects.LEVITATION) && this.random.nextFloat() < 0.05f) {
                potion = (Potion)ModRegistry.RISING_POTION.value();
            }
            ThrownPotion thrownPotion = new ThrownPotion(this.level(), (LivingEntity)this);
            thrownPotion.setItem(PotionUtils.setPotion((ItemStack)new ItemStack((ItemLike)Items.SPLASH_POTION), (Potion)potion));
            thrownPotion.setXRot(thrownPotion.getXRot() - -20.0f);
            thrownPotion.shoot(d, e + g * 0.2, f, 0.75f, 8.0f);
            if (!this.isSilent()) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WITCH_THROW, this.getSoundSource(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
            }
            this.level().addFreshEntity((Entity)thrownPotion);
        }
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return super.isInvulnerableTo(source) || source.getEntity() instanceof Witch;
    }

    public boolean addEffect(MobEffectInstance effectInstance, @Nullable Entity entity) {
        if (!effectInstance.getEffect().isBeneficial() && entity instanceof Witch) {
            return false;
        }
        return super.addEffect(effectInstance, entity);
    }

    public boolean canBeAffected(@NotNull MobEffectInstance potion) {
        return potion.getEffect() != MobEffects.WITHER && super.canBeAffected(potion);
    }
}

