/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.item.enchantment;

import fuzs.enderzoology.init.ModRegistry;
import fuzs.enderzoology.world.level.EnderTeleportHelper;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ThornsEnchantment;

public class RepellentEnchantment
extends ThornsEnchantment {
    public RepellentEnchantment(Enchantment.Rarity rarity, EquipmentSlot ... equipmentSlots) {
        super(rarity, equipmentSlots);
    }

    public int getMaxLevel() {
        return 4;
    }

    public boolean isTreasureOnly() {
        return true;
    }

    public boolean isTradeable() {
        return false;
    }

    public boolean isDiscoverable() {
        return false;
    }

    public void doPostHurt(LivingEntity target, Entity attacker, int level) {
        Map.Entry entry = EnchantmentHelper.getRandomItemWith((Enchantment)((Enchantment)ModRegistry.REPELLENT_ENCHANTMENT.value()), (LivingEntity)target);
        if (RepellentEnchantment.shouldHit((int)level, (RandomSource)target.getRandom())) {
            if (attacker instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)attacker;
                if (!attacker.level().isClientSide) {
                    EnderTeleportHelper.teleportEntity((ServerLevel)attacker.level(), livingEntity2, 8 + level * 4, false);
                }
            }
            if (entry != null) {
                ((ItemStack)entry.getValue()).hurtAndBreak(2, target, livingEntity -> livingEntity.broadcastBreakEvent((EquipmentSlot)entry.getKey()));
            }
        }
    }
}

