/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.level;

import com.google.common.collect.Lists;
import fuzs.enderzoology.EnderZoology;
import fuzs.enderzoology.init.ModRegistry;
import fuzs.enderzoology.world.entity.vehicle.MinecartCharge;
import fuzs.extensibleenums.api.v2.CommonAbstractions;
import fuzs.puzzleslib.api.init.v3.MinecartTypeRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public enum EnderExplosionType implements StringRepresentable
{
    ENDER("ender"),
    CONFUSION("confusion"),
    CONCUSSION("concussion");

    public static final StringRepresentable.EnumCodec<EnderExplosionType> CODEC;
    private final String name;
    private final AbstractMinecart.Type minecartType;

    private EnderExplosionType(String name) {
        this.name = name;
        this.minecartType = CommonAbstractions.createMinecartType((ResourceLocation)EnderZoology.id(name));
        MinecartTypeRegistry.INSTANCE.register(this.minecartType, (level, x, y, z) -> new MinecartCharge(this, level, x, y, z));
    }

    public List<MobEffectInstance> createEffects(int strength) {
        ArrayList effects = Lists.newArrayList();
        if (this.isTeleport()) {
            effects.add(new MobEffectInstance((MobEffect)ModRegistry.DISPLACEMENT_MOB_EFFECT.value(), 1, strength));
        }
        if (this.isConfusion()) {
            effects.add(new MobEffectInstance(MobEffects.CONFUSION, 100));
        }
        return effects;
    }

    public AbstractMinecart.Type getMinecartType() {
        return this.minecartType;
    }

    public Block getChargeBlock() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ENDER -> (Block)ModRegistry.ENDER_CHARGE_BLOCK.value();
            case CONFUSION -> (Block)ModRegistry.CONFUSING_CHARGE_BLOCK.value();
            case CONCUSSION -> (Block)ModRegistry.CONCUSSION_CHARGE_BLOCK.value();
        };
    }

    public EntityType<? extends MinecartTNT> getMinecartEntityType() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ENDER -> (EntityType)ModRegistry.ENDER_CHARGE_MINECART_ENTITY_TYPE.value();
            case CONFUSION -> (EntityType)ModRegistry.CONFUSING_CHARGE_MINECART_ENTITY_TYPE.value();
            case CONCUSSION -> (EntityType)ModRegistry.CONCUSSION_CHARGE_MINECART_ENTITY_TYPE.value();
        };
    }

    public Item getMinecartItem() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ENDER -> (Item)ModRegistry.ENDER_CHARGE_MINECART_ITEM.value();
            case CONFUSION -> (Item)ModRegistry.CONFUSING_CHARGE_MINECART_ITEM.value();
            case CONCUSSION -> (Item)ModRegistry.CONCUSSION_CHARGE_MINECART_ITEM.value();
        };
    }

    public String getSerializedName() {
        return this.name;
    }

    public boolean isTeleport() {
        return this != CONFUSION;
    }

    public boolean isConfusion() {
        return this != ENDER;
    }

    static {
        CODEC = StringRepresentable.fromEnum(EnderExplosionType::values);
    }
}

