/*
 * Decompiled with CFR 0.152.
 */
package edivad.edivadlib.network;

import edivad.edivadlib.network.EdivadLibPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IDirectionAwarePayloadHandlerBuilder;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;

public abstract class BasePacketHandler {
    protected BasePacketHandler(IEventBus modEventBus, String modId, String version) {
        modEventBus.addListener(RegisterPayloadHandlerEvent.class, event -> {
            IPayloadRegistrar registrar = event.registrar(modId).versioned(version);
            this.registerClientToServer(new PacketRegistrar(registrar, IDirectionAwarePayloadHandlerBuilder::server));
            this.registerServerToClient(new PacketRegistrar(registrar, IDirectionAwarePayloadHandlerBuilder::client));
        });
    }

    protected void registerClientToServer(PacketRegistrar registrar) {
    }

    protected void registerServerToClient(PacketRegistrar registrar) {
    }

    protected record PacketRegistrar(IPayloadRegistrar registrar, ContextAwareHandler handler) {
        public <T extends EdivadLibPacket> void play(ResourceLocation id, FriendlyByteBuf.Reader<T> reader) {
            this.registrar.play(id, reader, builder -> this.handler.accept(builder, EdivadLibPacket::handleMainThread));
        }
    }

    @FunctionalInterface
    protected static interface ContextAwareHandler {
        public <P extends CustomPacketPayload, T> void accept(IDirectionAwarePayloadHandlerBuilder<P, T> var1, T var2);
    }
}

