/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.api.client.neoforge;

import com.mojang.math.Transformation;
import earth.terrarium.athena.api.client.models.AthenaQuad;
import earth.terrarium.athena.api.client.neoforge.AthenaBlockElementFace;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3f;

@ApiStatus.Internal
public class ForgeAthenaUtils {
    public static final ModelState LOCKED_STATE = new SimpleModelState(Transformation.identity(), true);
    public static final ModelResourceLocation DEFAULT_MODEL = new ModelResourceLocation(new ResourceLocation("minecraft:missingno"), "");

    public static List<BakedQuad> bakeQuad(AthenaQuad quad, Direction direction, TextureAtlasSprite sprite) {
        Vector3f start = ForgeAthenaUtils.getStartPos(quad, direction);
        Vector3f end = ForgeAthenaUtils.getEndPos(quad, direction);
        AthenaBlockElementFace face = new AthenaBlockElementFace(quad, direction, start, end);
        BlockElement element = new BlockElement(start, end, Map.of(direction.getOpposite(), face), null, true);
        return UnbakedGeometryHelper.bakeElements(List.of(element), mat -> sprite, (ModelState)LOCKED_STATE, (ResourceLocation)DEFAULT_MODEL);
    }

    private static Vector3f getStartPos(AthenaQuad quad, Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> new Vector3f((1.0f - quad.right()) * 16.0f, quad.top() * 16.0f, quad.depth() * 16.0f);
            case Direction.SOUTH -> new Vector3f(quad.left() * 16.0f, quad.top() * 16.0f, (1.0f - quad.depth()) * 16.0f);
            case Direction.WEST -> new Vector3f(quad.depth() * 16.0f, quad.top() * 16.0f, quad.left() * 16.0f);
            case Direction.EAST -> new Vector3f((1.0f - quad.depth()) * 16.0f, quad.top() * 16.0f, (1.0f - quad.right()) * 16.0f);
            case Direction.DOWN -> new Vector3f(quad.left() * 16.0f, quad.depth() * 16.0f, quad.top() * 16.0f);
            case Direction.UP -> new Vector3f(quad.left() * 16.0f, (1.0f - quad.depth()) * 16.0f, (1.0f - quad.bottom()) * 16.0f);
        };
    }

    private static Vector3f getEndPos(AthenaQuad quad, Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> new Vector3f((1.0f - quad.left()) * 16.0f, quad.bottom() * 16.0f, quad.depth() * 16.0f);
            case Direction.SOUTH -> new Vector3f(quad.right() * 16.0f, quad.bottom() * 16.0f, (1.0f - quad.depth()) * 16.0f);
            case Direction.WEST -> new Vector3f(quad.depth() * 16.0f, quad.bottom() * 16.0f, quad.right() * 16.0f);
            case Direction.EAST -> new Vector3f((1.0f - quad.depth()) * 16.0f, quad.bottom() * 16.0f, (1.0f - quad.left()) * 16.0f);
            case Direction.DOWN -> new Vector3f(quad.right() * 16.0f, quad.depth() * 16.0f, quad.bottom() * 16.0f);
            case Direction.UP -> new Vector3f(quad.right() * 16.0f, quad.depth() * 16.0f, (1.0f - quad.top()) * 16.0f);
        };
    }
}

