/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.api.client.utils;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;

public final class AthenaUtils {
    public static final Logger LOGGER = LogUtils.getLogger();

    public static boolean asBool(Direction.AxisDirection axisDir) {
        return axisDir == Direction.AxisDirection.POSITIVE;
    }

    public static <T> T ternary(Direction.AxisDirection axisDir, T first, T second) {
        return axisDir == Direction.AxisDirection.POSITIVE ? first : second;
    }

    public static Pair<Direction, Direction> getMinMax(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> Pair.of((Object)Direction.WEST, (Object)Direction.EAST);
            case Direction.Axis.Y -> Pair.of((Object)Direction.UP, (Object)Direction.DOWN);
            case Direction.Axis.Z -> Pair.of((Object)Direction.NORTH, (Object)Direction.SOUTH);
        };
    }

    public static BlockPos getFacingPos(BlockPos pos, Direction facing, UrMom urMom) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> {
                switch (urMom) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case UP: {
                        yield pos.north();
                    }
                    case DOWN: {
                        yield pos.south();
                    }
                    case LEFT: {
                        yield pos.west();
                    }
                    case RIGHT: 
                }
                yield pos.east();
            }
            case Direction.DOWN -> {
                switch (urMom) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case UP: {
                        yield pos.south();
                    }
                    case DOWN: {
                        yield pos.north();
                    }
                    case LEFT: {
                        yield pos.west();
                    }
                    case RIGHT: 
                }
                yield pos.east();
            }
            case Direction.NORTH -> {
                switch (urMom) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case UP: {
                        yield pos.above();
                    }
                    case DOWN: {
                        yield pos.below();
                    }
                    case LEFT: {
                        yield pos.east();
                    }
                    case RIGHT: 
                }
                yield pos.west();
            }
            case Direction.SOUTH -> {
                switch (urMom) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case UP: {
                        yield pos.above();
                    }
                    case DOWN: {
                        yield pos.below();
                    }
                    case LEFT: {
                        yield pos.west();
                    }
                    case RIGHT: 
                }
                yield pos.east();
            }
            case Direction.WEST -> {
                switch (urMom) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case UP: {
                        yield pos.above();
                    }
                    case DOWN: {
                        yield pos.below();
                    }
                    case LEFT: {
                        yield pos.north();
                    }
                    case RIGHT: 
                }
                yield pos.south();
            }
            case Direction.EAST -> {
                switch (urMom) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case UP: {
                        yield pos.above();
                    }
                    case DOWN: {
                        yield pos.below();
                    }
                    case LEFT: {
                        yield pos.south();
                    }
                    case RIGHT: 
                }
                yield pos.north();
            }
        };
    }

    public static boolean getFromDir(BlockState state, Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> (Boolean)state.getValue((Property)BlockStateProperties.UP);
            case Direction.DOWN -> (Boolean)state.getValue((Property)BlockStateProperties.DOWN);
            case Direction.NORTH -> (Boolean)state.getValue((Property)BlockStateProperties.NORTH);
            case Direction.SOUTH -> (Boolean)state.getValue((Property)BlockStateProperties.SOUTH);
            case Direction.WEST -> (Boolean)state.getValue((Property)BlockStateProperties.WEST);
            case Direction.EAST -> (Boolean)state.getValue((Property)BlockStateProperties.EAST);
        };
    }

    public static enum UrMom {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

