/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.api.client.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.injectables.annotations.ExpectPlatform;
import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.CtmState;
import earth.terrarium.athena.api.client.utils.neoforge.CtmUtilsImpl;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public final class CtmUtils {
    private static final BiPredicate<BlockState, BlockState> FALSE = (selfState, otherState) -> false;
    private static final BiPredicate<BlockState, BlockState> STATE = (selfState, otherState) -> selfState == otherState;
    private static final BiPredicate<BlockState, BlockState> IS = (selfState, otherState) -> selfState.is(otherState.getBlock());

    public static int getTexture(boolean first, boolean second, boolean firstSecond) {
        if (first && second) {
            return firstSecond ? 1 : 2;
        }
        return first ? 3 : (second ? 4 : 0);
    }

    public static Int2ObjectMap<Material> parseCtmMaterials(JsonObject json) {
        Int2ObjectArrayMap materials = new Int2ObjectArrayMap();
        materials.put(0, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"particle")));
        materials.put(2, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"center")));
        materials.put(3, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"vertical")));
        materials.put(4, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"horizontal")));
        materials.put(1, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"empty")));
        return materials;
    }

    public static Material blockMat(String id) {
        return new Material(TextureAtlas.LOCATION_BLOCKS, new ResourceLocation(id));
    }

    public static <I, O> O tryParse(I input, Function<I, O> parser) {
        try {
            return parser.apply(input);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Rotation getPillarRotation(Direction.Axis axis, Direction direction) {
        void var1_1;
        return CtmUtilsImpl.getPillarRotation(axis, (Direction)var1_1);
    }

    public static BiPredicate<BlockState, BlockState> parseCondition(JsonObject json) {
        if (!json.has("connect_to")) {
            return STATE;
        }
        JsonElement jsonElement = json.get("connect_to");
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            return CtmUtils.parseConditionInternal(jsonObject);
        }
        return FALSE;
    }

    private static BiPredicate<BlockState, BlockState> parseConditionInternal(JsonObject json) {
        return switch (GsonHelper.getAsString((JsonObject)json, (String)"type", (String)"")) {
            case "not" -> CtmUtils.parseNotCondition(json);
            case "and" -> CtmUtils.parseListCondition(json, BiPredicate::and);
            case "or" -> CtmUtils.parseListCondition(json, BiPredicate::or);
            case "xor" -> CtmUtils.parseXorCondition(json);
            case "state" -> CtmUtils.parseStateCondition(json);
            case "tag" -> CtmUtils.parseTagCondition(json);
            case "sameBlock" -> IS;
            case "sameState" -> STATE;
            default -> FALSE;
        };
    }

    private static BiPredicate<BlockState, BlockState> parseListCondition(JsonObject json, BinaryOperator<BiPredicate<BlockState, BlockState>> mapper) {
        List<BiPredicate> conditions = CtmUtils.unwrapConditions(json).stream().map(CtmUtils::parseConditionInternal).toList();
        if (conditions.isEmpty()) {
            return FALSE;
        }
        if (conditions.size() == 1) {
            return conditions.get(0);
        }
        return conditions.stream().reduce(mapper).orElseThrow();
    }

    private static BiPredicate<BlockState, BlockState> parseXorCondition(JsonObject json) {
        List<JsonObject> conditionsJson = CtmUtils.unwrapConditions(json);
        if (conditionsJson.size() != 2) {
            return FALSE;
        }
        BiPredicate<BlockState, BlockState> first = CtmUtils.parseConditionInternal(conditionsJson.get(0));
        BiPredicate<BlockState, BlockState> second = CtmUtils.parseConditionInternal(conditionsJson.get(1));
        return (selfState, otherState) -> first.test((BlockState)selfState, (BlockState)otherState) ^ second.test((BlockState)selfState, (BlockState)otherState);
    }

    private static List<JsonObject> unwrapConditions(JsonObject json) {
        ArrayList<JsonObject> conditionList = new ArrayList<JsonObject>();
        JsonElement jsonElement = json.get("conditions");
        if (jsonElement instanceof JsonArray) {
            JsonArray array = (JsonArray)jsonElement;
            for (JsonElement jsonElement2 : array) {
                if (!(jsonElement2 instanceof JsonObject)) continue;
                JsonObject jsonObject = (JsonObject)jsonElement2;
                conditionList.add(jsonObject);
            }
        }
        return conditionList;
    }

    private static BiPredicate<BlockState, BlockState> parseNotCondition(JsonObject json) {
        JsonElement jsonElement = json.get("condition");
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            return CtmUtils.parseConditionInternal(jsonObject).negate();
        }
        return (selfState, otherState) -> false;
    }

    private static BiPredicate<BlockState, BlockState> parseStateCondition(JsonObject json) {
        Optional blockOpt = Optional.ofNullable(GsonHelper.getAsString((JsonObject)json, (String)"block", null)).map(ResourceLocation::tryParse).flatMap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getOptional(arg_0));
        if (blockOpt.isEmpty()) {
            return FALSE;
        }
        Block block = (Block)blockOpt.get();
        if (!json.has("properties")) {
            return (selfState, otherState) -> otherState.is(block);
        }
        JsonElement propertiesElem = json.get("properties");
        if (!propertiesElem.isJsonObject()) {
            return FALSE;
        }
        HashMap properties = new HashMap();
        for (Map.Entry jsonEntry : propertiesElem.getAsJsonObject().asMap().entrySet()) {
            @Nullable Property property = block.getStateDefinition().getProperty((String)jsonEntry.getKey());
            if (property == null || !GsonHelper.isStringValue((JsonElement)((JsonElement)jsonEntry.getValue()))) continue;
            property.getValue(((JsonElement)jsonEntry.getValue()).getAsString()).ifPresent(value -> properties.put(property, value));
        }
        return (selfState, otherState) -> {
            if (!otherState.is(block)) {
                return false;
            }
            for (Map.Entry propertyTestValue : properties.entrySet()) {
                if (otherState.getValue((Property)propertyTestValue.getKey()) == propertyTestValue.getValue()) continue;
                return false;
            }
            return true;
        };
    }

    private static BiPredicate<BlockState, BlockState> parseTagCondition(JsonObject json) {
        TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryParse((String)json.get("tag").getAsString()));
        return (selfState, otherState) -> otherState.is(tag);
    }

    public static CtmState.ConnectionCheck check(AppearanceAndTintGetter level, BlockState state, BlockPos pos, Direction direction, BiPredicate<BlockState, BlockState> predicate) {
        return (fromPos, fromState, fromAppearance) -> predicate.test(level.getAppearance(state, pos, direction, fromState, fromPos), fromAppearance);
    }

    public static boolean checkRelative(AppearanceAndTintGetter level, BlockState state, BlockPos pos, Direction direction) {
        BlockPos relativePos = pos.relative(direction);
        BlockState otherState = level.getBlockState(relativePos);
        BlockState stateAppearance = level.getAppearance(state, pos, direction, otherState, relativePos);
        BlockState otherStateAppearance = level.getAppearance(otherState, relativePos, direction.getOpposite(), state, pos);
        return !stateAppearance.isAir() && otherStateAppearance.is(stateAppearance.getBlock());
    }
}

