/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.impl.loading;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class AthenaDataLoader {
    private static Function<ResourceLocation, List<ModelBakery.LoadedJson>> getter;

    public static void setGetter(Function<ResourceLocation, List<ModelBakery.LoadedJson>> getter) {
        AthenaDataLoader.getter = getter;
    }

    public static JsonObject getData(ResourceLocation modelType, ResourceLocation modelId) {
        if (getter == null) {
            return null;
        }
        List<ModelBakery.LoadedJson> jsons = getter.apply(AthenaDataLoader.convertModelIdToBlockStatePath(modelId));
        if (jsons == null) {
            return null;
        }
        for (ModelBakery.LoadedJson json : jsons) {
            JsonElement jsonElement = json.data();
            if (!(jsonElement instanceof JsonObject)) continue;
            JsonObject object = (JsonObject)jsonElement;
            String type = GsonHelper.getAsString((JsonObject)object, (String)"athena:loader", (String)"");
            if (!modelType.toString().equals(type)) continue;
            return object;
        }
        return null;
    }

    private static ResourceLocation convertModelIdToBlockStatePath(ResourceLocation modelId) {
        return new ResourceLocation(modelId.getNamespace(), "blockstates/" + modelId.getPath() + ".json");
    }
}

