/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.neoforge.client;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import earth.terrarium.athena.api.client.models.neoforge.FactoryManagerImpl;
import earth.terrarium.athena.api.client.utils.AthenaUnbakedModelLoader;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;

public class AthenaGeometryLoader
implements IGeometryLoader<Unbaked> {
    public Unbaked read(JsonObject json, JsonDeserializationContext context) throws JsonParseException {
        String id = GsonHelper.getAsString((JsonObject)json, (String)"athena:loader");
        ResourceLocation loaderId = ResourceLocation.tryParse((String)id);
        if (loaderId == null) {
            throw new JsonParseException("Invalid loader id: " + id);
        }
        AthenaUnbakedModelLoader loader = FactoryManagerImpl.get(loaderId);
        if (loader == null) {
            throw new JsonParseException("Unknown loader: " + loaderId);
        }
        return new Unbaked(loader, json);
    }

    public record Unbaked(AthenaUnbakedModelLoader loader, JsonObject json) implements IUnbakedGeometry<Unbaked>
    {
        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation id) {
            return this.loader.loadModel(this.json).bake(baker, spriteGetter, modelState, id);
        }
    }
}

