/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.client.screens;

import earth.terrarium.chipped.common.menus.WorkbenchMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class SlotWidget
extends AbstractWidget {
    public static final ResourceLocation TEXTURE = new ResourceLocation("chipped", "textures/gui/sprites/slot.png");
    private final ItemStack stack;
    private final WorkbenchMenu menu;
    private final int minY;
    private final int maxY;

    public SlotWidget(ItemStack stack, WorkbenchMenu menu, int minY, int maxY) {
        super(0, 0, 18, 18, CommonComponents.EMPTY);
        this.stack = stack;
        this.menu = menu;
        this.minY = minY;
        this.maxY = maxY;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.blit(TEXTURE, this.getX(), this.getY(), 0.0f, 0.0f, 18, 18, 18, 18);
        graphics.renderItem(this.stack, this.getX() + 1, this.getY() + 1);
        if (this.isMouseOver(mouseX, mouseY)) {
            AbstractContainerScreen.renderSlotHighlight((GuiGraphics)graphics, (int)(this.getX() + 1), (int)(this.getY() + 1), (int)0);
        }
    }

    public void renderTooltip(GuiGraphics graphics, Font font, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY) && !this.stack.isEmpty()) {
            graphics.renderTooltip(font, Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)this.stack), this.stack.getTooltipImage(), mouseX, mouseY);
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return super.isMouseOver(mouseX, mouseY) && mouseY >= (double)this.minY && mouseY <= (double)this.maxY;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.clicked(mouseX, mouseY)) {
            if (this.stack.isEmpty() || mouseY < (double)this.minY || mouseY > (double)this.maxY) {
                return false;
            }
            this.menu.setChosenStack(this.stack);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

