/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.client.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamresourceful.resourcefullib.client.scissor.ClosingScissorBox;
import com.teamresourceful.resourcefullib.client.screens.AbstractContainerCursorScreen;
import com.teamresourceful.resourcefullib.client.utils.RenderUtils;
import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.chipped.client.screens.RenderWindowWidget;
import earth.terrarium.chipped.client.screens.SlotWidget;
import earth.terrarium.chipped.common.menus.WorkbenchMenu;
import earth.terrarium.chipped.common.network.NetworkHandler;
import earth.terrarium.chipped.common.network.ServerboundCraftPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WorkbenchScreen
extends AbstractContainerCursorScreen<WorkbenchMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("chipped", "textures/gui/container/workbench.png");
    public static final WidgetSprites SINGLE_BLOCK_BUTTON_SPRITES = new WidgetSprites(new ResourceLocation("chipped", "single_block_button"), new ResourceLocation("chipped", "single_block_button_highlighted"));
    public static final WidgetSprites HORIZONTAL_BLOCKS_BUTTON_SPRITES = new WidgetSprites(new ResourceLocation("chipped", "horizontal_blocks_button"), new ResourceLocation("chipped", "horizontal_blocks_button_highlighted"));
    public static final WidgetSprites VERTICAL_BLOCKS_BUTTON_SPRITES = new WidgetSprites(new ResourceLocation("chipped", "vertical_blocks_button"), new ResourceLocation("chipped", "vertical_blocks_button_highlighted"));
    public static final WidgetSprites TWO_BY_TWO_BUTTON_SPRITES = new WidgetSprites(new ResourceLocation("chipped", "two_by_two_button"), new ResourceLocation("chipped", "two_by_two_button_highlighted"));
    public static final WidgetSprites BUTTON_SPRITES = new WidgetSprites(new ResourceLocation("chipped", "button"), new ResourceLocation("chipped", "button_highlighted"));
    public static final int YELLOW = 0x70FFFF00;
    public static final int BLUE = 0x700000FF;
    public static final int DARK_GRAY = 0x70000000;
    private static final Component PREVIEW_TEXT = Component.translatable((String)"text.chipped.preview");
    private static final Component CRAFT_TEXT = Component.translatable((String)"text.chipped.craft");
    private static final Component CRAFT_ALL_TEXT = Component.translatable((String)"text.chipped.craft_all");
    private static final Component SINGLE_TEXT = Component.translatable((String)"text.chipped.single");
    private static final Component HORIZONTAL_TEXT = Component.translatable((String)"text.chipped.horizontal");
    private static final Component VERTICAL_TEXT = Component.translatable((String)"text.chipped.vertical");
    private static final Component TWO_BY_TWO_TEXT = Component.translatable((String)"text.chipped.two_by_two");
    protected EditBox searchBox;
    protected double scrollAmount;
    protected RenderWindowWidget renderWindow;
    protected GridLayout grid;
    protected final List<SlotWidget> slotWidgets = new ArrayList<SlotWidget>();
    protected RenderWindowWidget.Mode mode = RenderWindowWidget.Mode.TWO_BY_TWO;

    public WorkbenchScreen(WorkbenchMenu container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.imageWidth = 256;
        this.imageHeight = 256;
        this.titleLabelX = 88;
        this.titleLabelY = 14;
        this.inventoryLabelY = 155;
        this.inventoryLabelX = 88;
    }

    protected void init() {
        super.init();
        this.searchBox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.leftPos + 105, this.topPos + 27, 115, 11, (Component)Component.empty()));
        this.searchBox.setTextColor(-1);
        this.searchBox.setTextColorUneditable(-1);
        this.searchBox.setBordered(false);
        this.searchBox.setMaxLength(50);
        this.searchBox.setResponder(this::onSearchBarChanged);
        this.searchBox.setEditable(false);
        ((ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 9, this.topPos + 121, 18, 18, SINGLE_BLOCK_BUTTON_SPRITES, button -> {
            this.mode = RenderWindowWidget.Mode.SINGLE_BLOCK;
        }))).setTooltip(Tooltip.create((Component)SINGLE_TEXT));
        ((ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 27, this.topPos + 121, 18, 18, HORIZONTAL_BLOCKS_BUTTON_SPRITES, button -> {
            this.mode = RenderWindowWidget.Mode.HORIZONTAL_BLOCK;
        }))).setTooltip(Tooltip.create((Component)HORIZONTAL_TEXT));
        ((ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 45, this.topPos + 121, 18, 18, VERTICAL_BLOCKS_BUTTON_SPRITES, button -> {
            this.mode = RenderWindowWidget.Mode.VERTICAL_BLOCK;
        }))).setTooltip(Tooltip.create((Component)VERTICAL_TEXT));
        ((ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 63, this.topPos + 121, 18, 18, TWO_BY_TWO_BUTTON_SPRITES, button -> {
            this.mode = RenderWindowWidget.Mode.TWO_BY_TWO;
        }))).setTooltip(Tooltip.create((Component)TWO_BY_TWO_TEXT));
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 9, this.topPos + 101, 72, 18, BUTTON_SPRITES, button -> this.craft()));
        this.addSlotWidgets();
        this.renderWindow = (RenderWindowWidget)this.addRenderableWidget((GuiEventListener)new RenderWindowWidget(this.leftPos + 9, this.topPos + 26, 72, 72, this::mode, this::state));
    }

    private void addSlotWidgets() {
        this.slotWidgets.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.slotWidgets.clear();
        int left = (this.width - this.imageWidth) / 2;
        int top = (this.height - this.imageHeight) / 2;
        this.grid = new GridLayout(left + 85, top + 41);
        List<ItemStack> results = ((WorkbenchMenu)this.menu).results();
        int rows = Math.max(6, Mth.ceil((float)((float)results.size() / 9.0f)));
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < rows; ++j) {
                int index = i + j * 9;
                ItemStack stack = results.size() > index ? results.get(index) : ItemStack.EMPTY;
                SlotWidget slot = (SlotWidget)this.addWidget((GuiEventListener)new SlotWidget(stack, (WorkbenchMenu)this.menu, top + 40, top + 141));
                this.grid.addChild((LayoutElement)slot, j, i);
                this.slotWidgets.add(slot);
            }
        }
        this.grid.arrangeElements();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        int left = (this.width - this.imageWidth) / 2;
        int top = (this.height - this.imageHeight) / 2;
        this.grid.setY(top + 41 - (int)this.scrollAmount);
        try (ClosingScissorBox ignored = RenderUtils.createScissorBox((Minecraft)Objects.requireNonNull(this.minecraft), (PoseStack)graphics.pose(), (int)(left + 84), (int)(top + 40), (int)163, (int)109);){
            for (SlotWidget widget : this.slotWidgets) {
                widget.renderWidget(graphics, mouseX, mouseY, partialTick);
            }
        }
        for (SlotWidget widget : this.slotWidgets) {
            widget.renderTooltip(graphics, this.font, mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int left = (this.width - this.imageWidth) / 2;
        int top = (this.height - this.imageHeight) / 2;
        graphics.blit(TEXTURE, left, top, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        graphics.drawString(this.font, PREVIEW_TEXT, left + 11, top + 14, 0x404040, false);
        graphics.drawCenteredString(this.font, WorkbenchScreen.hasShiftDown() ? CRAFT_ALL_TEXT : CRAFT_TEXT, left + 45, top + 106, 0x404040);
        ItemStack stack = ((WorkbenchMenu)this.menu).chosenStack();
        if (stack.isEmpty()) {
            return;
        }
        ItemStack selectedStack = ((WorkbenchMenu)this.menu).selectedStack();
        if (selectedStack.isEmpty()) {
            return;
        }
        for (Slot slot : ((WorkbenchMenu)this.menu).slots) {
            if (selectedStack.equals(slot.getItem()) || ItemStack.isSameItem((ItemStack)selectedStack, (ItemStack)slot.getItem()) && WorkbenchScreen.hasShiftDown()) {
                graphics.fill(slot.x + left - 1, slot.y + top - 1, slot.x + left + 17, slot.y + top + 17, 0x70FFFF00);
                continue;
            }
            if (ItemStack.isSameItem((ItemStack)selectedStack, (ItemStack)slot.getItem())) {
                graphics.fill(slot.x + left - 1, slot.y + top - 1, slot.x + left + 17, slot.y + top + 17, 0x700000FF);
                continue;
            }
            graphics.fill(slot.x + left - 1, slot.y + top - 1, slot.x + left + 17, slot.y + top + 17, 0x70000000);
        }
    }

    private void onSearchBarChanged(String filter) {
        this.scrollAmount = 0.0;
        ((WorkbenchMenu)this.menu).updateResults(filter);
        this.addSlotWidgets();
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
        super.slotClicked(slot, slotId, mouseButton, type);
        this.addSlotWidgets();
        this.searchBox.setEditable(!((WorkbenchMenu)this.menu).selectedStack().isEmpty());
        this.scrollAmount = 0.0;
        ((WorkbenchMenu)this.menu).setFilter(this.searchBox.getValue());
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        if (this.getFocused() == this.searchBox) {
            return this.searchBox.keyPressed(keyCode, scanCode, modifiers) || this.searchBox.canConsumeInput() || super.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.getFocused() != this.searchBox) {
            this.setFocused(null);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (((WorkbenchMenu)this.menu).results().size() <= 54) {
            return false;
        }
        this.setScrollAmount(this.scrollAmount - scrollY * 16.0 / 2.0);
        return true;
    }

    protected void setScrollAmount(double amount) {
        int rows = Mth.ceil((float)((float)((WorkbenchMenu)this.menu).results().size() / 9.0f));
        this.scrollAmount = Mth.clamp((double)amount, (double)0.0, (double)(rows * 18 - 108));
    }

    public void craft() {
        if (!((WorkbenchMenu)this.menu).selectedStack().isEmpty()) {
            NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundCraftPacket(((WorkbenchMenu)this.menu).chosenStack(), WorkbenchScreen.hasShiftDown()));
            Objects.requireNonNull(this.minecraft).getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_TAKE_RESULT, (float)1.0f, (float)1.0f));
            ((WorkbenchMenu)this.menu).reset();
            this.addSlotWidgets();
            this.scrollAmount = 0.0;
            this.setFocused(null);
        }
    }

    public RenderWindowWidget.Mode mode() {
        return this.mode;
    }

    public BlockState state() {
        Block block = Block.byItem((Item)((WorkbenchMenu)this.menu).chosenStack().getItem());
        if (block instanceof IronBarsBlock) {
            return (BlockState)((BlockState)block.defaultBlockState().setValue((Property)IronBarsBlock.NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)IronBarsBlock.SOUTH, (Comparable)Boolean.valueOf(true));
        }
        BlockState state = block.defaultBlockState();
        return state.isAir() ? null : state;
    }
}

