/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.common.blocks;

import com.mojang.serialization.MapCodec;
import earth.terrarium.chipped.common.menus.WorkbenchMenuProvider;
import java.util.Locale;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class WorkbenchBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<WorkbenchBlock> CODEC = WorkbenchBlock.simpleCodec(WorkbenchBlock::new);
    public static final EnumProperty<WorkbenchModelType> MODEL_TYPE = EnumProperty.create((String)"model", WorkbenchModelType.class);

    public WorkbenchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(MODEL_TYPE, (Comparable)((Object)WorkbenchModelType.MAIN)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, MODEL_TYPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public InteractionResult use(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        player.openMenu((MenuProvider)new WorkbenchMenuProvider((Component)this.getName()));
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos otherpos;
        BlockState otherstate;
        if (level.isClientSide) {
            super.playerWillDestroy(level, pos, state, player);
            return state;
        }
        WorkbenchModelType workbenchModel = (WorkbenchModelType)((Object)state.getValue(MODEL_TYPE));
        if (workbenchModel == WorkbenchModelType.MAIN && (otherstate = level.getBlockState(otherpos = pos.relative(((Direction)state.getValue((Property)FACING)).getClockWise()))).getBlock() == this) {
            level.setBlock(otherpos, Blocks.AIR.defaultBlockState(), 3);
            level.levelEvent(player, 2001, otherpos, Block.getId((BlockState)otherstate));
        }
        if (workbenchModel == WorkbenchModelType.SIDE && (otherstate = level.getBlockState(otherpos = pos.relative(((Direction)state.getValue((Property)FACING)).getCounterClockWise()))).getBlock() == this) {
            level.setBlock(otherpos, Blocks.AIR.defaultBlockState(), 3);
            level.levelEvent(player, 2001, otherpos, Block.getId((BlockState)otherstate));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide) {
            BlockPos blockpos = pos.relative(((Direction)state.getValue((Property)FACING)).getClockWise());
            level.setBlock(blockpos, (BlockState)state.setValue(MODEL_TYPE, (Comparable)((Object)WorkbenchModelType.SIDE)), 3);
            level.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return state.getValue(MODEL_TYPE) == WorkbenchModelType.MAIN ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    @Deprecated
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getClockWise())).canBeReplaced();
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public static enum WorkbenchModelType implements StringRepresentable
    {
        MAIN,
        SIDE;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.getSerializedName();
        }
    }
}

