/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.common.compat.jei;

import earth.terrarium.chipped.common.compat.jei.WorkbenchCategory;
import earth.terrarium.chipped.common.recipes.ChippedRecipe;
import earth.terrarium.chipped.common.registry.ModItems;
import earth.terrarium.chipped.common.registry.ModRecipeTypes;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class ChippedJeiPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("chipped", "jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new WorkbenchCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.WORKBENCH.get()).forEach(recipe -> ((ChippedRecipe)recipe.value()).ingredients().forEach(ingredient -> registration.addRecipes(WorkbenchCategory.RECIPE, List.of(ingredient))));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Item)ModItems.BOTANIST_WORKBENCH.get()).getDefaultInstance(), new RecipeType[]{WorkbenchCategory.RECIPE});
        registration.addRecipeCatalyst(((Item)ModItems.GLASSBLOWER.get()).getDefaultInstance(), new RecipeType[]{WorkbenchCategory.RECIPE});
        registration.addRecipeCatalyst(((Item)ModItems.CARPENTERS_TABLE.get()).getDefaultInstance(), new RecipeType[]{WorkbenchCategory.RECIPE});
        registration.addRecipeCatalyst(((Item)ModItems.LOOM_TABLE.get()).getDefaultInstance(), new RecipeType[]{WorkbenchCategory.RECIPE});
        registration.addRecipeCatalyst(((Item)ModItems.MASON_TABLE.get()).getDefaultInstance(), new RecipeType[]{WorkbenchCategory.RECIPE});
        registration.addRecipeCatalyst(((Item)ModItems.ALCHEMY_BENCH.get()).getDefaultInstance(), new RecipeType[]{WorkbenchCategory.RECIPE});
        registration.addRecipeCatalyst(((Item)ModItems.TINKERING_TABLE.get()).getDefaultInstance(), new RecipeType[]{WorkbenchCategory.RECIPE});
    }
}

