/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.common.menus;

import earth.terrarium.chipped.common.recipes.ChippedRecipe;
import earth.terrarium.chipped.common.registry.ModMenuTypes;
import earth.terrarium.chipped.common.registry.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorkbenchMenu
extends AbstractContainerMenu {
    protected final Inventory inventory;
    protected final Level level;
    private int selectedStackId;
    private ItemStack selectedStack = ItemStack.EMPTY;
    private ItemStack chosenStack = ItemStack.EMPTY;
    @Nullable
    private String filter;
    private final List<ItemStack> results = new ArrayList<ItemStack>();

    public WorkbenchMenu(int containerId, Inventory inventory) {
        super((MenuType)ModMenuTypes.WORKBENCH.get(), containerId);
        this.inventory = inventory;
        this.level = inventory.player.level();
        this.addPlayerInvSlots();
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    protected void addPlayerInvSlots() {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new InventorySlot((Container)this.inventory, j + i * 9 + 9, this.getPlayerInvXOffset() + j * 18, this.getPlayerInvYOffset() + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new InventorySlot((Container)this.inventory, i, this.getPlayerInvXOffset() + i * 18, this.getPlayerInvYOffset() + 58));
        }
    }

    public int getPlayerInvXOffset() {
        return 86;
    }

    public int getPlayerInvYOffset() {
        return 167;
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        this.selectStack(slotId);
        super.clicked(slotId, button, clickType, player);
    }

    public void selectStack(int slotId) {
        if (slotId < 0 || slotId >= this.slots.size()) {
            return;
        }
        this.selectedStackId = ((Slot)this.slots.get(slotId)).getContainerSlot();
        this.chosenStack = this.selectedStack = ((Slot)this.slots.get(slotId)).getItem();
        this.updateResults(this.filter);
    }

    public void updateResults(@Nullable String filter) {
        if (this.selectedStack.isEmpty()) {
            return;
        }
        this.filter = filter;
        SimpleContainer container = new SimpleContainer(new ItemStack[]{this.selectedStack});
        this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.WORKBENCH.get(), (Container)container, this.level).ifPresentOrElse(recipe -> {
            this.results.clear();
            ((ChippedRecipe)recipe.value()).getResults(container.getItem(0)).forEach(result -> {
                if (filter == null || Util.isBlank((String)filter) || result.getDisplayName().getString().toLowerCase(Locale.ROOT).contains(filter.toLowerCase(Locale.ROOT))) {
                    this.results.add((ItemStack)result);
                }
            });
        }, this::reset);
    }

    public void craft(ItemStack stack, boolean replaceAll) {
        if (stack.isEmpty()) {
            return;
        }
        boolean canCraft = false;
        for (ItemStack result : this.results) {
            if (!ItemStack.isSameItemSameTags((ItemStack)result, (ItemStack)stack)) continue;
            canCraft = true;
            break;
        }
        if (!canCraft) {
            return;
        }
        this.inventory.setItem(this.selectedStackId, stack.copyWithCount(this.inventory.getItem(this.selectedStackId).getCount()));
        if (replaceAll) {
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                if (!ItemStack.isSameItem((ItemStack)this.inventory.getItem(i), (ItemStack)this.selectedStack)) continue;
                this.inventory.setItem(i, stack.copyWithCount(this.inventory.getItem(i).getCount()));
            }
        }
        this.reset();
    }

    public void reset() {
        this.selectedStackId = 0;
        this.selectedStack = ItemStack.EMPTY;
        this.chosenStack = ItemStack.EMPTY;
        this.results.clear();
    }

    public ItemStack selectedStack() {
        return this.selectedStack;
    }

    public ItemStack chosenStack() {
        return this.chosenStack;
    }

    public void setChosenStack(ItemStack stack) {
        this.chosenStack = stack;
    }

    public List<ItemStack> results() {
        return this.results;
    }

    public Level level() {
        return this.level;
    }

    public void setFilter(@Nullable String filter) {
        this.filter = filter;
    }

    private static class InventorySlot
    extends Slot {
        public InventorySlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean mayPickup(Player player) {
            return false;
        }
    }
}

