/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.base.object.ObjectByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.ExtraByteCodecs;
import com.teamresourceful.resourcefullib.common.recipe.CodecRecipe;
import com.teamresourceful.resourcefullib.common.recipe.CodecRecipeSerializer;
import earth.terrarium.chipped.common.registry.ModRecipeSerializers;
import earth.terrarium.chipped.common.registry.ModRecipeTypes;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record ChippedRecipe(List<Ingredient> ingredients) implements CodecRecipe<Container>
{
    public static final Codec<ChippedRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC.listOf().fieldOf("ingredients").forGetter(ChippedRecipe::ingredients)).apply((Applicative)instance, ChippedRecipe::new));
    public static final ByteCodec<ChippedRecipe> NETWORK_CODEC = ObjectByteCodec.create((ObjectEntryByteCodec)ExtraByteCodecs.INGREDIENT.listOf().fieldOf(ChippedRecipe::ingredients), ChippedRecipe::new);

    public Stream<ItemStack> getResults(ItemStack stack) {
        return stack.isEmpty() ? Stream.empty() : this.ingredients.stream().filter(ingredient -> ingredient.test(stack)).map(Ingredient::getItems).flatMap(Stream::of);
    }

    public boolean matches(Container container, Level level) {
        ItemStack stack = container.getItem(0);
        return !stack.isEmpty() && this.ingredients.stream().anyMatch(ingredient -> ingredient.test(stack));
    }

    public CodecRecipeSerializer<? extends CodecRecipe<Container>> serializer() {
        return (CodecRecipeSerializer)ModRecipeSerializers.WORKBENCH.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.WORKBENCH.get();
    }
}

