/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.fastmap;

import com.google.common.base.Preconditions;
import malte0811.ferritecore.fastmap.FastMapKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;

public class BinaryFastMapKey<T extends Comparable<T>>
extends FastMapKey<T> {
    private final byte firstBitInValue;
    private final byte firstBitAfterValue;

    public BinaryFastMapKey(Property<T> property, int mapFactor) {
        super(property);
        Preconditions.checkArgument((boolean)Mth.isPowerOfTwo((int)mapFactor));
        int addedFactor = Mth.smallestEncompassingPowerOfTwo((int)this.numValues());
        Preconditions.checkState((this.numValues() <= addedFactor ? 1 : 0) != 0);
        Preconditions.checkState((addedFactor < 2 * this.numValues() ? 1 : 0) != 0);
        int setBitInBaseFactor = Mth.log2((int)mapFactor);
        int setBitInAddedFactor = Mth.log2((int)addedFactor);
        Preconditions.checkState((setBitInBaseFactor + setBitInAddedFactor <= 31 ? 1 : 0) != 0);
        this.firstBitInValue = (byte)setBitInBaseFactor;
        this.firstBitAfterValue = (byte)(setBitInBaseFactor + setBitInAddedFactor);
    }

    @Override
    public T getValue(int mapIndex) {
        int clearAbove = mapIndex & this.lowestNBits(this.firstBitAfterValue);
        return this.byInternalIndex(clearAbove >>> this.firstBitInValue);
    }

    @Override
    public int replaceIn(int mapIndex, T newValue) {
        int newPartialIndex = this.toPartialMapIndex((Comparable<?>)newValue);
        if (newPartialIndex < 0) {
            return -1;
        }
        int keepMask = ~this.lowestNBits(this.firstBitAfterValue) | this.lowestNBits(this.firstBitInValue);
        return keepMask & mapIndex | newPartialIndex;
    }

    @Override
    public int toPartialMapIndex(Comparable<?> value) {
        int internalIndex = this.getInternalIndex(value);
        if (internalIndex < 0 || internalIndex >= this.numValues()) {
            return -1;
        }
        return internalIndex << this.firstBitInValue;
    }

    @Override
    public int getFactorToNext() {
        return 1 << this.firstBitAfterValue - this.firstBitInValue;
    }

    private int lowestNBits(byte n) {
        if (n >= 32) {
            return -1;
        }
        return (1 << n) - 1;
    }
}

