/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.server;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotAttribute;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;
import top.theillusivec4.curios.common.inventory.container.CuriosContainerProvider;
import top.theillusivec4.curios.common.inventory.container.CuriosContainerV2;
import top.theillusivec4.curios.common.network.client.CPacketDestroy;
import top.theillusivec4.curios.common.network.client.CPacketOpenCurios;
import top.theillusivec4.curios.common.network.client.CPacketOpenVanilla;
import top.theillusivec4.curios.common.network.client.CPacketPage;
import top.theillusivec4.curios.common.network.client.CPacketScroll;
import top.theillusivec4.curios.common.network.client.CPacketToggleCosmetics;
import top.theillusivec4.curios.common.network.client.CPacketToggleRender;
import top.theillusivec4.curios.common.network.server.SPacketGrabbedItem;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncRender;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncStack;

public class CuriosServerPayloadHandler {
    private static final CuriosServerPayloadHandler INSTANCE = new CuriosServerPayloadHandler();

    public static CuriosServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    private static void handleData(PlayPayloadContext ctx, Runnable handler) {
        ctx.workHandler().submitAsync(handler).exceptionally(e -> {
            ctx.packetHandler().disconnect((Component)Component.translatable((String)"curios.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handlerToggleRender(CPacketToggleRender data, PlayPayloadContext ctx) {
        CuriosServerPayloadHandler.handleData(ctx, () -> ctx.player().ifPresent(player -> CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.getStacksHandler(data.identifier())).ifPresent(stacksHandler -> {
            NonNullList<Boolean> renderStatuses = stacksHandler.getRenders();
            if (renderStatuses.size() > data.index()) {
                boolean value = (Boolean)renderStatuses.get(data.index()) == false;
                renderStatuses.set(data.index(), (Object)value);
                PacketDistributor.TRACKING_ENTITY_AND_SELF.with(player).send(new CustomPacketPayload[]{new SPacketSyncRender(player.getId(), data.identifier(), data.index(), value)});
            }
        })));
    }

    public void handlePage(CPacketPage data, PlayPayloadContext ctx) {
        CuriosServerPayloadHandler.handleData(ctx, () -> ctx.player().ifPresent(player -> {
            AbstractContainerMenu container = player.containerMenu;
            if (container instanceof CuriosContainerV2 && container.containerId == data.windowId()) {
                if (data.next()) {
                    ((CuriosContainerV2)container).nextPage();
                } else {
                    ((CuriosContainerV2)container).prevPage();
                }
            }
        }));
    }

    public void handlerToggleCosmetics(CPacketToggleCosmetics data, PlayPayloadContext ctx) {
        CuriosServerPayloadHandler.handleData(ctx, () -> ctx.player().ifPresent(player -> {
            AbstractContainerMenu container = player.containerMenu;
            if (container instanceof CuriosContainerV2 && container.containerId == data.windowId()) {
                ((CuriosContainerV2)container).toggleCosmetics();
            }
        }));
    }

    public void handleScroll(CPacketScroll data, PlayPayloadContext ctx) {
        CuriosServerPayloadHandler.handleData(ctx, () -> ctx.player().ifPresent(player -> {
            AbstractContainerMenu container = player.containerMenu;
            if (container instanceof CuriosContainer && container.containerId == data.windowId()) {
                ((CuriosContainer)container).scrollToIndex(data.index());
            }
        }));
    }

    public void handleOpenVanilla(CPacketOpenVanilla data, PlayPayloadContext ctx) {
        CuriosServerPayloadHandler.handleData(ctx, () -> ctx.player().ifPresent(player -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ItemStack stack = player.isCreative() ? data.carried() : player.containerMenu.getCarried();
                player.containerMenu.setCarried(ItemStack.EMPTY);
                serverPlayer.doCloseContainer();
                if (!stack.isEmpty()) {
                    if (!player.isCreative()) {
                        player.containerMenu.setCarried(stack);
                    }
                    PacketDistributor.PLAYER.with((Object)serverPlayer).send(new CustomPacketPayload[]{new SPacketGrabbedItem(stack)});
                }
            }
        }));
    }

    public void handleOpenCurios(CPacketOpenCurios data, PlayPayloadContext ctx) {
        CuriosServerPayloadHandler.handleData(ctx, () -> ctx.player().ifPresent(player -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ItemStack stack = player.isCreative() ? data.carried() : player.containerMenu.getCarried();
                player.containerMenu.setCarried(ItemStack.EMPTY);
                player.openMenu((MenuProvider)new CuriosContainerProvider());
                if (!stack.isEmpty()) {
                    player.containerMenu.setCarried(stack);
                    PacketDistributor.PLAYER.with((Object)serverPlayer).send(new CustomPacketPayload[]{new SPacketGrabbedItem(stack)});
                }
            }
        }));
    }

    public void handleDestroyPacket(CPacketDestroy data, PlayPayloadContext ctx) {
        CuriosServerPayloadHandler.handleData(ctx, () -> ctx.player().ifPresent(player -> CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.getCurios().values().forEach(stacksHandler -> {
            IDynamicStackHandler stackHandler = stacksHandler.getStacks();
            IDynamicStackHandler cosmeticStackHandler = stacksHandler.getCosmeticStacks();
            String id = stacksHandler.getIdentifier();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                NonNullList<Boolean> renderStates = stacksHandler.getRenders();
                SlotContext slotContext = new SlotContext(id, (LivingEntity)player, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false);
                UUID uuid = CuriosApi.getSlotUuid(slotContext);
                ItemStack stack = stackHandler.getStackInSlot(i);
                Multimap<Attribute, AttributeModifier> map = CuriosApi.getAttributeModifiers(slotContext, uuid, stack);
                HashMultimap slots = HashMultimap.create();
                HashSet<SlotAttribute> toRemove = new HashSet<SlotAttribute>();
                for (Attribute attribute : map.keySet()) {
                    if (!(attribute instanceof SlotAttribute)) continue;
                    SlotAttribute wrapper = (SlotAttribute)attribute;
                    slots.putAll((Object)wrapper.getIdentifier(), (Iterable)map.get((Object)attribute));
                    toRemove.add(wrapper);
                }
                for (Attribute attribute : toRemove) {
                    map.removeAll((Object)attribute);
                }
                player.getAttributes().removeAttributeModifiers(map);
                handler.removeSlotModifiers((Multimap<String, AttributeModifier>)slots);
                CuriosApi.getCurio(stack).ifPresent(curio -> curio.onUnequip(slotContext, stack));
                stackHandler.setStackInSlot(i, ItemStack.EMPTY);
                PacketDistributor.TRACKING_ENTITY_AND_SELF.with(player).send(new CustomPacketPayload[]{new SPacketSyncStack(player.getId(), id, i, ItemStack.EMPTY, SPacketSyncStack.HandlerType.EQUIPMENT.ordinal(), new CompoundTag())});
                cosmeticStackHandler.setStackInSlot(i, ItemStack.EMPTY);
                PacketDistributor.TRACKING_ENTITY_AND_SELF.with(player).send(new CustomPacketPayload[]{new SPacketSyncStack(player.getId(), id, i, ItemStack.EMPTY, SPacketSyncStack.HandlerType.COSMETIC.ordinal(), new CompoundTag())});
            }
        }))));
    }
}

