/*
 * Decompiled with CFR 0.152.
 */
package io.github.prismwork.emitrades;

import com.google.common.collect.ImmutableSet;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import io.github.prismwork.emitrades.config.EMITradesConfig;
import io.github.prismwork.emitrades.recipe.VillagerTrade;
import io.github.prismwork.emitrades.util.EntityEmiStack;
import io.github.prismwork.emitrades.util.TradeProfile;
import io.github.prismwork.emitrades.util.XPlatUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.File;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EmiEntrypoint
public class EMITradesPlugin
implements EmiPlugin {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"EMI Trades");
    public static final VillagerProfession WANDERING_TRADER_PLACEHOLDER = new VillagerProfession("wandering_trader", entry -> false, entry -> false, ImmutableSet.builder().build(), ImmutableSet.builder().build(), SoundEvents.WANDERING_TRADER_YES);
    public static final EmiRecipeCategory VILLAGER_TRADES = new EmiRecipeCategory(new ResourceLocation("emitrades", "villager_trades"), (EmiRenderable)EmiStack.of((ItemLike)Items.EMERALD));
    public static EMITradesConfig.Config CONFIG;
    private static final File CONFIG_FILE;

    public void register(EmiRegistry registry) {
        CONFIG = EMITradesConfig.load(CONFIG_FILE);
        registry.addCategory(VILLAGER_TRADES);
        RandomSource random = RandomSource.create();
        for (VillagerProfession profession : BuiltInRegistries.VILLAGER_PROFESSION) {
            Villager villager = (Villager)((EntityType)BuiltInRegistries.ENTITY_TYPE.get(new ResourceLocation("minecraft", "villager"))).create((Level)Minecraft.getInstance().level);
            if (villager != null) {
                villager.setVillagerData(villager.getVillagerData().setProfession(profession).setLevel(5));
                registry.addWorkstation(VILLAGER_TRADES, (EmiIngredient)EntityEmiStack.ofScaled((Entity)villager, 8.0f));
            }
            AtomicInteger id = new AtomicInteger();
            Int2ObjectMap offers2 = (Int2ObjectMap)VillagerTrades.TRADES.get(profession);
            if (offers2 == null || offers2.isEmpty()) continue;
            for (int level = 0; level < 5; ++level) {
                Villager villager1 = (Villager)((EntityType)BuiltInRegistries.ENTITY_TYPE.get(new ResourceLocation("minecraft", "villager"))).create((Level)Minecraft.getInstance().level);
                if (villager1 != null) {
                    villager1.setVillagerData(villager1.getVillagerData().setProfession(profession).setLevel(level + 1));
                }
                for (VillagerTrades.ItemListing offer : (VillagerTrades.ItemListing[])offers2.get(level + 1)) {
                    if (EMITradesPlugin.isVanillaFactory(offer)) {
                        registry.addRecipe((EmiRecipe)new VillagerTrade(new TradeProfile.DefaultImpl(profession, offer, level + 1, (AbstractVillager)villager1), id.get()));
                        id.getAndIncrement();
                        continue;
                    }
                    try {
                        int attempts = 5;
                        TreeSet<MerchantOffer> genOffers = new TreeSet<MerchantOffer>(this::compareOffers);
                        while (attempts > 0) {
                            MerchantOffer inOffer = offer.getOffer((Entity)Minecraft.getInstance().player, random);
                            if (genOffers.add(inOffer)) {
                                ++attempts;
                                continue;
                            }
                            --attempts;
                        }
                        int finalLevel = level;
                        genOffers.forEach(tradeOffer -> {
                            registry.addRecipe((EmiRecipe)new VillagerTrade(new TradeProfile.DefaultImpl(profession, new FakeFactory((MerchantOffer)tradeOffer), finalLevel + 1, (AbstractVillager)villager1), id.get()));
                            id.getAndIncrement();
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        WanderingTrader wanderingTrader = (WanderingTrader)((EntityType)BuiltInRegistries.ENTITY_TYPE.get(new ResourceLocation("minecraft", "wandering_trader"))).create((Level)Minecraft.getInstance().level);
        registry.addWorkstation(VILLAGER_TRADES, (EmiIngredient)EntityEmiStack.of((Entity)wanderingTrader));
        AtomicInteger wanderingTraderId = new AtomicInteger();
        VillagerTrades.WANDERING_TRADER_TRADES.forEach((lvl, offers) -> {
            for (VillagerTrades.ItemListing offer : offers) {
                if (EMITradesPlugin.isVanillaFactory(offer)) {
                    registry.addRecipe((EmiRecipe)new VillagerTrade(new TradeProfile.DefaultImpl(WANDERING_TRADER_PLACEHOLDER, offer, (int)lvl, (AbstractVillager)wanderingTrader), wanderingTraderId.get()));
                    wanderingTraderId.getAndIncrement();
                    continue;
                }
                try {
                    int attempts = 5;
                    TreeSet<MerchantOffer> genOffers = new TreeSet<MerchantOffer>(this::compareOffers);
                    while (attempts > 0) {
                        MerchantOffer inOffer = offer.getOffer((Entity)Minecraft.getInstance().player, random);
                        if (genOffers.add(inOffer)) {
                            ++attempts;
                            continue;
                        }
                        --attempts;
                    }
                    int finalLevel = lvl;
                    genOffers.forEach(tradeOffer -> {
                        registry.addRecipe((EmiRecipe)new VillagerTrade(new TradeProfile.DefaultImpl(WANDERING_TRADER_PLACEHOLDER, new FakeFactory((MerchantOffer)tradeOffer), finalLevel, (AbstractVillager)wanderingTrader), wanderingTraderId.get()));
                        wanderingTraderId.getAndIncrement();
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        LOGGER.info("Reloaded.");
    }

    private static boolean isVanillaFactory(VillagerTrades.ItemListing offer) {
        return offer instanceof VillagerTrades.SuspiciousStewForEmerald || offer instanceof VillagerTrades.EnchantedItemForEmeralds || offer instanceof VillagerTrades.EnchantBookForEmeralds || offer instanceof VillagerTrades.TreasureMapForEmeralds || offer instanceof VillagerTrades.TippedArrowForItemsAndEmeralds || offer instanceof VillagerTrades.DyedArmorForEmeralds || offer instanceof VillagerTrades.EmeraldsForVillagerTypeItem || offer instanceof VillagerTrades.ItemsForEmeralds || offer instanceof VillagerTrades.EmeraldForItems || offer instanceof VillagerTrades.ItemsAndEmeraldsToItems;
    }

    private int compareOffers(@NotNull MerchantOffer a, @NotNull MerchantOffer b) {
        int diff = BuiltInRegistries.ITEM.getId((Object)a.getBaseCostA().getItem()) - BuiltInRegistries.ITEM.getId((Object)b.getBaseCostA().getItem());
        if (diff != 0) {
            return diff;
        }
        diff = BuiltInRegistries.ITEM.getId((Object)a.getCostB().getItem()) - BuiltInRegistries.ITEM.getId((Object)b.getCostB().getItem());
        if (diff != 0) {
            return diff;
        }
        diff = BuiltInRegistries.ITEM.getId((Object)a.getResult().getItem()) - BuiltInRegistries.ITEM.getId((Object)b.getResult().getItem());
        return diff;
    }

    static {
        CONFIG_FILE = XPlatUtils.getConfigPath().resolve("emitrades.json5").toFile();
    }

    @ApiStatus.Internal
    public static final class FakeFactory
    implements VillagerTrades.ItemListing {
        public final ItemStack first;
        public final ItemStack second;
        public final ItemStack sell;

        public FakeFactory(MerchantOffer offer) {
            this.first = offer.getBaseCostA();
            this.second = offer.getCostB();
            this.sell = offer.getResult();
        }

        @Nullable
        public MerchantOffer getOffer(Entity entity, RandomSource random) {
            throw new AssertionError((Object)"Nobody should use this");
        }
    }
}

