/*
 * Decompiled with CFR 0.152.
 */
package io.github.prismwork.emitrades.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import io.github.prismwork.emitrades.EMITradesPlugin;
import io.github.prismwork.emitrades.util.EntityEmiStack;
import io.github.prismwork.emitrades.util.ListEmiStack;
import io.github.prismwork.emitrades.util.TradeProfile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class VillagerTrade
implements EmiRecipe {
    private final TradeProfile profile;
    private final List<EmiIngredient> inputs;
    private final List<EmiStack> outputs;
    private final List<EmiIngredient> catalysts;
    private final int id;
    private final MutableComponent title;

    public VillagerTrade(TradeProfile profile, int id) {
        this.profile = profile;
        this.inputs = new ArrayList<EmiIngredient>();
        this.outputs = new ArrayList<EmiStack>();
        this.catalysts = profile.villager() != null ? List.of(EntityEmiStack.ofScaled((Entity)profile.villager(), 12.0f)) : List.of();
        this.id = id;
        VillagerProfession internalProf = profile.profession();
        this.title = internalProf.equals((Object)EMITradesPlugin.WANDERING_TRADER_PLACEHOLDER) ? Component.translatable((String)"emi.emitrades.placeholder.wandering_trader") : Component.translatable((String)("entity.minecraft.villager." + profile.profession().name().substring(profile.profession().name().lastIndexOf(":") + 1))).append(" - ").append((Component)Component.translatable((String)("emi.emitrades.profession.lvl." + profile.level())));
        VillagerTrades.ItemListing offer = profile.offer();
        if (offer instanceof VillagerTrades.EmeraldForItems) {
            VillagerTrades.EmeraldForItems factory = (VillagerTrades.EmeraldForItems)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemStack)factory.itemStack, (long)factory.emeraldAmount));
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            this.outputs.add(0, EmiStack.of((ItemLike)Items.EMERALD));
        } else if (offer instanceof VillagerTrades.ItemsForEmeralds) {
            VillagerTrades.ItemsForEmeralds factory = (VillagerTrades.ItemsForEmeralds)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemLike)Items.EMERALD, (long)factory.emeraldCost));
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            this.outputs.add(0, EmiStack.of((ItemStack)factory.itemStack));
        } else if (offer instanceof VillagerTrades.SuspiciousStewForEmerald) {
            VillagerTrades.SuspiciousStewForEmerald factory = (VillagerTrades.SuspiciousStewForEmerald)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemLike)Items.EMERALD, (long)1L));
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            ItemStack stack = new ItemStack((ItemLike)Items.SUSPICIOUS_STEW, 1);
            SuspiciousStewItem.appendMobEffects((ItemStack)stack, (List)factory.effects);
            this.outputs.add(0, EmiStack.of((ItemStack)stack));
        } else if (offer instanceof VillagerTrades.ItemsAndEmeraldsToItems) {
            VillagerTrades.ItemsAndEmeraldsToItems factory = (VillagerTrades.ItemsAndEmeraldsToItems)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemLike)Items.EMERALD, (long)factory.emeraldCost));
            this.inputs.add(1, (EmiIngredient)EmiStack.of((ItemStack)factory.fromItem));
            this.outputs.add(0, EmiStack.of((ItemStack)factory.toItem));
        } else if (offer instanceof VillagerTrades.EnchantedItemForEmeralds) {
            VillagerTrades.EnchantedItemForEmeralds factory = (VillagerTrades.EnchantedItemForEmeralds)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemLike)Items.EMERALD, (long)Math.min(factory.baseEmeraldCost + 5, 64)));
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            ArrayList out = new ArrayList();
            int enchantability = factory.itemStack.getItem().getEnchantmentValue();
            int power = 21 + (enchantability / 4 + 1) + (enchantability / 4 + 1);
            EnchantmentHelper.getAvailableEnchantmentResults((int)power, (ItemStack)factory.itemStack, (boolean)false).forEach(entry -> {
                Enchantment enchantment = entry.enchantment;
                for (int i = enchantment.getMinLevel(); i <= enchantment.getMaxLevel(); ++i) {
                    ItemStack stack = factory.itemStack.copy();
                    stack.enchant(entry.enchantment, i);
                    out.add(EmiStack.of((ItemStack)stack));
                }
            });
            this.outputs.add(0, new ListEmiStack(out, factory.itemStack.getCount()));
        } else if (offer instanceof VillagerTrades.EmeraldsForVillagerTypeItem) {
            VillagerTrades.EmeraldsForVillagerTypeItem factory = (VillagerTrades.EmeraldsForVillagerTypeItem)offer;
            ArrayList stacks = new ArrayList();
            factory.trades.values().forEach(item -> stacks.add(EmiStack.of((ItemLike)item)));
            this.inputs.add(0, (EmiIngredient)new ListEmiIngredient(stacks, (long)factory.cost));
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            this.outputs.add(0, EmiStack.of((ItemLike)Items.EMERALD));
        } else if (offer instanceof VillagerTrades.TippedArrowForItemsAndEmeralds) {
            VillagerTrades.TippedArrowForItemsAndEmeralds factory = (VillagerTrades.TippedArrowForItemsAndEmeralds)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemLike)Items.EMERALD, (long)factory.emeraldCost));
            this.inputs.add(1, (EmiIngredient)EmiStack.of((ItemLike)factory.fromItem, (long)factory.fromCount));
            ArrayList out = new ArrayList();
            BuiltInRegistries.POTION.stream().filter(potion -> !potion.getEffects().isEmpty() && PotionBrewing.isBrewablePotion((Potion)potion)).forEach(potion -> {
                ItemStack stack = PotionUtils.setPotion((ItemStack)factory.toItem, (Potion)potion);
                out.add(EmiStack.of((ItemStack)stack));
            });
            this.outputs.add(0, new ListEmiStack(out, factory.toCount));
        } else if (offer instanceof VillagerTrades.EnchantBookForEmeralds) {
            VillagerTrades.EnchantBookForEmeralds factory = (VillagerTrades.EnchantBookForEmeralds)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemLike)Items.EMERALD, (long)5L));
            this.inputs.add(1, (EmiIngredient)EmiStack.of((ItemLike)Items.BOOK));
            ArrayList out = new ArrayList();
            factory.tradeableEnchantments.forEach(enchantment -> {
                int min = Math.max(enchantment.getMinLevel(), factory.minLevel);
                int max = Math.min(enchantment.getMaxLevel(), factory.maxLevel);
                for (int i = min; i <= max; ++i) {
                    ItemStack stack = EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(enchantment, i));
                    out.add(EmiStack.of((ItemStack)stack));
                }
            });
            this.outputs.add(0, new ListEmiStack(out, 1L));
        } else if (offer instanceof VillagerTrades.TreasureMapForEmeralds) {
            VillagerTrades.TreasureMapForEmeralds factory = (VillagerTrades.TreasureMapForEmeralds)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemLike)Items.EMERALD, (long)factory.emeraldCost));
            this.inputs.add(1, (EmiIngredient)EmiStack.of((ItemLike)Items.COMPASS));
            this.outputs.add(0, EmiStack.of((ItemLike)Items.FILLED_MAP));
        } else if (offer instanceof VillagerTrades.DyedArmorForEmeralds) {
            VillagerTrades.DyedArmorForEmeralds factory = (VillagerTrades.DyedArmorForEmeralds)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemLike)Items.EMERALD, (long)factory.value));
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            this.outputs.add(0, EmiStack.of((ItemLike)factory.item));
        } else if (offer instanceof EMITradesPlugin.FakeFactory) {
            EMITradesPlugin.FakeFactory factory = (EMITradesPlugin.FakeFactory)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemStack)factory.first));
            this.inputs.add(1, (EmiIngredient)EmiStack.of((ItemStack)factory.second));
            this.outputs.add(0, EmiStack.of((ItemStack)factory.sell));
        } else {
            this.inputs.add(0, (EmiIngredient)EmiStack.EMPTY);
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            this.outputs.add(0, EmiStack.EMPTY);
        }
    }

    public List<EmiIngredient> getCatalysts() {
        return this.catalysts;
    }

    public EmiRecipeCategory getCategory() {
        return EMITradesPlugin.VILLAGER_TRADES;
    }

    @Nullable
    public ResourceLocation getId() {
        return new ResourceLocation("emitrades", "villager_trades/" + this.profile.profession().name().substring(this.profile.profession().name().lastIndexOf(":") + 1) + "_" + this.id);
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        Font textRenderer = Minecraft.getInstance().font;
        int extraWidth = this.catalysts.isEmpty() ? 0 : 21;
        return this.catalysts.isEmpty() || !EMITradesPlugin.CONFIG.enable3DVillagerModelInRecipes ? Math.max(86, textRenderer.width((FormattedText)this.title) + 2) : Math.max(extraWidth + 85, extraWidth + textRenderer.width((FormattedText)this.title));
    }

    public int getDisplayHeight() {
        return 28;
    }

    public void addWidgets(WidgetHolder widgets) {
        Font textRenderer = Minecraft.getInstance().font;
        if (this.catalysts.isEmpty() || !EMITradesPlugin.CONFIG.enable3DVillagerModelInRecipes) {
            widgets.addText((Component)this.title, (this.getDisplayWidth() - textRenderer.width((FormattedText)this.title)) / 2, 0, 0xFFFFFF, true);
            widgets.addSlot(this.inputs.get(0), this.getDisplayWidth() / 2 - 42, 10);
            widgets.addSlot(this.inputs.get(1), this.getDisplayWidth() / 2 - 22, 10);
            widgets.addTexture(EmiTexture.EMPTY_ARROW, this.getDisplayWidth() / 2 - 3, 10);
            SlotWidget outputSlot = new SlotWidget((EmiIngredient)this.outputs.get(0), this.getDisplayWidth() / 2 + 22, 10).recipeContext((EmiRecipe)this);
            this.wrapOutput(widgets, outputSlot);
        } else {
            SlotWidget villagerSlot = new SlotWidget(this.catalysts.get(0), 1, 6).drawBack(false);
            AbstractVillager abstractVillager = this.profile.villager();
            if (abstractVillager instanceof Villager) {
                Villager villager = (Villager)abstractVillager;
                villagerSlot.appendTooltip((Component)Component.translatable((String)("emi.emitrades.profession.lvl." + villager.getVillagerData().getLevel())).withStyle(ChatFormatting.YELLOW));
            }
            widgets.add((Widget)villagerSlot);
            widgets.addText((Component)this.title, 21, 0, 0xFFFFFF, true);
            widgets.addSlot(this.inputs.get(0), 21, 10);
            widgets.addSlot(this.inputs.get(1), 41, 10);
            widgets.addTexture(EmiTexture.EMPTY_ARROW, 60, 10);
            SlotWidget outputSlot = new SlotWidget((EmiIngredient)this.outputs.get(0), 85, 10).recipeContext((EmiRecipe)this);
            this.wrapOutput(widgets, outputSlot);
        }
    }

    private void wrapOutput(WidgetHolder widgets, SlotWidget outputSlot) {
        if (this.profile.offer() instanceof VillagerTrades.DyedArmorForEmeralds) {
            outputSlot = outputSlot.appendTooltip((Component)Component.translatable((String)"emi.emitrades.random_colored").withStyle(ChatFormatting.YELLOW));
        } else if (this.profile.offer() instanceof VillagerTrades.SuspiciousStewForEmerald) {
            outputSlot = outputSlot.appendTooltip((Component)Component.translatable((String)"emi.emitrades.random_effect").withStyle(ChatFormatting.YELLOW));
        } else if (this.profile.offer() instanceof VillagerTrades.TreasureMapForEmeralds) {
            outputSlot = outputSlot.appendTooltip((Component)Component.translatable((String)"emi.emitrades.random_structure").withStyle(ChatFormatting.YELLOW));
        }
        widgets.add((Widget)outputSlot);
    }
}

