/*
 * Decompiled with CFR 0.152.
 */
package io.github.prismwork.emitrades.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.screen.tooltip.RemainderTooltipComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class EntityEmiStack
extends EmiStack {
    @Nullable
    private final Entity entity;
    private final float scale;

    protected EntityEmiStack(@Nullable Entity entity, float scale) {
        this.entity = entity;
        this.scale = scale;
    }

    public static EntityEmiStack of(@Nullable Entity entity) {
        return EntityEmiStack.ofScaled(entity, 8.0f);
    }

    public static EntityEmiStack ofScaled(@Nullable Entity entity, float scale) {
        return new EntityEmiStack(entity, scale);
    }

    public EmiStack copy() {
        EntityEmiStack stack = EntityEmiStack.ofScaled(this.entity, this.scale);
        stack.setRemainder(this.getRemainder().copy());
        stack.comparison = this.comparison;
        return stack;
    }

    public boolean isEmpty() {
        return this.entity == null;
    }

    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
        if (this.entity != null) {
            MouseHandler mouse = Minecraft.getInstance().mouseHandler;
            Entity entity = this.entity;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                EntityEmiStack.drawLivingEntity(draw, x, y, this.scale, (float)mouse.xpos(), (float)mouse.ypos(), living);
            } else {
                EntityEmiStack.drawEntity(draw, x, y, this.scale, (float)mouse.xpos(), (float)mouse.ypos(), this.entity);
            }
        }
    }

    public CompoundTag getNbt() {
        return Optional.ofNullable(this.entity).map(e -> e.saveWithoutId(new CompoundTag())).orElse(new CompoundTag());
    }

    public Object getKey() {
        return this.entity;
    }

    public ResourceLocation getId() {
        if (this.entity == null) {
            throw new RuntimeException("Entity is null");
        }
        return BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.entity.getType());
    }

    public List<Component> getTooltipText() {
        return List.of(this.getName());
    }

    public List<ClientTooltipComponent> getTooltip() {
        ArrayList<ClientTooltipComponent> list = new ArrayList<ClientTooltipComponent>();
        if (this.entity != null) {
            String mod;
            list.addAll(this.getTooltipText().stream().map(EmiPort::ordered).map(ClientTooltipComponent::create).toList());
            Entity entity = this.entity;
            if (entity instanceof Villager) {
                Villager villager = (Villager)entity;
                mod = EmiUtil.getModName((String)BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)villager.getVillagerData().getProfession()).getNamespace());
            } else {
                mod = EmiUtil.getModName((String)BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.entity.getType()).getNamespace());
            }
            list.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.literal((String)mod, (ChatFormatting[])new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}))));
            if (!this.getRemainder().isEmpty()) {
                list.add((ClientTooltipComponent)new RemainderTooltipComponent((EmiIngredient)this));
            }
        }
        return list;
    }

    public Component getName() {
        return this.entity != null ? this.entity.getName() : EmiPort.literal((String)"yet another missingno");
    }

    public static void drawLivingEntity(GuiGraphics ctx, int x, int y, float size, float mouseX, float mouseY, LivingEntity entity) {
        float mouseX0 = (float)(ctx.guiWidth() + 51) - mouseX;
        float mouseY0 = (float)(ctx.guiHeight() + 75 - 50) - mouseY;
        float f = (float)Math.atan(mouseX0 / 40.0f);
        float g = (float)Math.atan(mouseY0 / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(g * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float h = entity.yBodyRot;
        float i = entity.getYRot();
        float j = entity.getXRot();
        float k = entity.yHeadRotO;
        float l = entity.yHeadRot;
        entity.yBodyRot = 180.0f + f * 20.0f;
        entity.setYRot(180.0f + f * 40.0f);
        entity.setXRot(-g * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        EntityEmiStack.draw(ctx, x, y, size, quaternionf, quaternionf2, (Entity)entity);
        entity.yBodyRot = h;
        entity.setYRot(i);
        entity.setXRot(j);
        entity.yHeadRotO = k;
        entity.yHeadRot = l;
    }

    public static void drawEntity(GuiGraphics ctx, int x, int y, float size, float mouseX, float mouseY, Entity entity) {
        float mouseX0 = (float)(ctx.guiWidth() + 51) - mouseX;
        float mouseY0 = (float)(ctx.guiHeight() + 75 - 50) - mouseY;
        float f = (float)Math.atan(mouseX0 / 40.0f);
        float g = (float)Math.atan(mouseY0 / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(g * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float i = entity.getYRot();
        float j = entity.getXRot();
        entity.setYRot(180.0f + f * 40.0f);
        entity.setXRot(-g * 20.0f);
        EntityEmiStack.draw(ctx, x, y, size, quaternionf, quaternionf2, entity);
        entity.setYRot(i);
        entity.setXRot(j);
    }

    private static void draw(GuiGraphics ctx, int x, int y, float size, Quaternionf quaternion, @Nullable Quaternionf quaternion2, Entity entity) {
        ctx.pose().pushPose();
        ctx.pose().translate((double)(x + 8), (double)(y + 16), 50.0);
        ctx.pose().mulPoseMatrix(new Matrix4f().scaling(size, size, -size));
        ctx.pose().mulPose(quaternion);
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        if (quaternion2 != null) {
            quaternion2.conjugate();
            dispatcher.overrideCameraOrientation(quaternion2);
        }
        dispatcher.setRenderShadow(false);
        RenderSystem.runAsFancy(() -> dispatcher.render(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, ctx.pose(), (MultiBufferSource)ctx.bufferSource(), 0xF000F0));
        ctx.flush();
        dispatcher.setRenderShadow(true);
        ctx.pose().popPose();
        Lighting.setupFor3DItems();
    }
}

