/*
 * Decompiled with CFR 0.152.
 */
package io.github.prismwork.emitrades.util;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.render.EmiRender;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.screen.tooltip.IngredientTooltipComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ListEmiStack
extends EmiStack {
    private final List<? extends EmiIngredient> ingredients;
    private final List<EmiStack> fullList;
    private long amount;
    private float chance = 1.0f;

    public ListEmiStack(List<? extends EmiIngredient> ingredients, long amount) {
        this.ingredients = ingredients;
        this.fullList = ingredients.stream().flatMap(i -> i.getEmiStacks().stream()).toList();
        if (this.fullList.isEmpty()) {
            throw new IllegalArgumentException("ListEmiIngredient cannot be empty");
        }
        this.amount = amount;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ListEmiStack) {
            ListEmiStack other = (ListEmiStack)((Object)obj);
            return other.getEmiStacks().equals(this.getEmiStacks());
        }
        return false;
    }

    public int hashCode() {
        return this.fullList.hashCode();
    }

    public EmiStack copy() {
        ListEmiStack stack = new ListEmiStack(this.ingredients, this.amount);
        stack.setChance(this.chance);
        return stack;
    }

    public boolean isEmpty() {
        return this.ingredients.isEmpty();
    }

    public String toString() {
        return "ListEmiStack" + this.getEmiStacks();
    }

    public List<EmiStack> getEmiStacks() {
        return this.fullList;
    }

    public long getAmount() {
        return this.amount;
    }

    public EmiStack setAmount(long amount) {
        this.amount = amount;
        return this;
    }

    public float getChance() {
        return this.chance;
    }

    public EmiStack setChance(float chance) {
        this.chance = chance;
        return this;
    }

    public CompoundTag getNbt() {
        return new CompoundTag();
    }

    public Object getKey() {
        return this.ingredients;
    }

    public ResourceLocation getId() {
        return new ResourceLocation("emitrades", "list_emi_stack");
    }

    public List<Component> getTooltipText() {
        return null;
    }

    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
        int item = (int)(System.currentTimeMillis() / 1000L % (long)this.ingredients.size());
        EmiIngredient current = this.ingredients.get(item);
        if ((flags & 1) != 0) {
            current.render(draw, x, y, delta, -3);
        }
        if ((flags & 2) != 0) {
            current.copy().setAmount(this.amount).render(draw, x, y, delta, 2);
        }
        if ((flags & 4) != 0) {
            EmiRender.renderIngredientIcon((EmiIngredient)this, (GuiGraphics)draw, (int)x, (int)y);
        }
    }

    public List<ClientTooltipComponent> getTooltip() {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable((String)"tooltip.emi.accepts"))));
        tooltip.add(new IngredientTooltipComponent(this.ingredients));
        int item = (int)(System.currentTimeMillis() / 1000L % (long)this.ingredients.size());
        tooltip.addAll(this.ingredients.get(item).copy().setAmount(this.amount).getTooltip());
        return tooltip;
    }

    public Component getName() {
        return EmiPort.literal((String)"");
    }
}

