/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.ingredients.fluid;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.TagUtil;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class FluidIngredientHelper<T>
implements IIngredientHelper<T> {
    private final ISubtypeManager subtypeManager;
    private final IColorHelper colorHelper;
    private final IPlatformFluidHelperInternal<T> platformFluidHelper;
    private final IPlatformRegistry<Fluid> registry;
    private final IIngredientTypeWithSubtypes<Fluid, T> fluidType;

    public FluidIngredientHelper(ISubtypeManager subtypeManager, IColorHelper colorHelper, IPlatformFluidHelperInternal<T> platformFluidHelper) {
        this.subtypeManager = subtypeManager;
        this.colorHelper = colorHelper;
        this.platformFluidHelper = platformFluidHelper;
        this.registry = Services.PLATFORM.getRegistry(Registries.FLUID);
        this.fluidType = platformFluidHelper.getFluidIngredientType();
    }

    @Override
    public IIngredientType<T> getIngredientType() {
        return this.platformFluidHelper.getFluidIngredientType();
    }

    @Override
    public String getDisplayName(T ingredient) {
        Component displayName = this.platformFluidHelper.getDisplayName(ingredient);
        return displayName.getString();
    }

    @Override
    public String getUniqueId(T ingredient, UidContext context) {
        Fluid fluid = this.fluidType.getBase(ingredient);
        ResourceLocation registryName = this.getRegistryName(ingredient, fluid);
        StringBuilder result = new StringBuilder().append("fluid:").append(registryName);
        String subtypeInfo = this.subtypeManager.getSubtypeInfo(this.fluidType, ingredient, context);
        if (!subtypeInfo.isEmpty()) {
            result.append(":");
            result.append(subtypeInfo);
        }
        return result.toString();
    }

    @Override
    public String getWildcardId(T ingredient) {
        Fluid fluid = this.fluidType.getBase(ingredient);
        ResourceLocation registryName = this.getRegistryName(ingredient, fluid);
        return "fluid:" + registryName;
    }

    @Override
    public Iterable<Integer> getColors(T ingredient) {
        return this.platformFluidHelper.getStillFluidSprite(ingredient).map(fluidStillSprite -> {
            int renderColor = this.platformFluidHelper.getColorTint(ingredient);
            return this.colorHelper.getColors((TextureAtlasSprite)fluidStillSprite, renderColor, 1);
        }).orElseGet(List::of);
    }

    @Override
    public ResourceLocation getResourceLocation(T ingredient) {
        Fluid fluid = this.fluidType.getBase(ingredient);
        return this.getRegistryName(ingredient, fluid);
    }

    private ResourceLocation getRegistryName(T ingredient, Fluid fluid) {
        return this.registry.getRegistryName(fluid).orElseThrow(() -> {
            String ingredientInfo = this.getErrorInfo(ingredient);
            return new IllegalStateException("null registry name for: " + ingredientInfo);
        });
    }

    @Override
    public ItemStack getCheatItemStack(T ingredient) {
        Fluid fluid = this.fluidType.getBase(ingredient);
        Item filledBucket = fluid.getBucket();
        return new ItemStack((ItemLike)filledBucket);
    }

    @Override
    public T copyIngredient(T ingredient) {
        return this.platformFluidHelper.copy(ingredient);
    }

    @Override
    public T normalizeIngredient(T ingredient) {
        return this.platformFluidHelper.normalize(ingredient);
    }

    @Override
    public Stream<ResourceLocation> getTagStream(T ingredient) {
        Fluid fluid = this.fluidType.getBase(ingredient);
        return BuiltInRegistries.FLUID.getResourceKey((Object)fluid).flatMap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).getHolder(arg_0)).map(Holder::tags).orElse(Stream.of(new TagKey[0])).map(TagKey::location);
    }

    @Override
    public String getErrorInfo(@Nullable T ingredient) {
        if (ingredient == null) {
            return "null";
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(ingredient.getClass());
        Fluid fluid = this.fluidType.getBase(ingredient);
        if (fluid != null) {
            Component displayName = this.platformFluidHelper.getDisplayName(ingredient);
            toStringHelper.add("Fluid", (Object)displayName.getString());
        } else {
            toStringHelper.add("Fluid", (Object)"null");
        }
        toStringHelper.add("Amount", this.platformFluidHelper.getAmount(ingredient));
        this.platformFluidHelper.getTag(ingredient).ifPresent(tag -> toStringHelper.add("Tag", tag));
        return toStringHelper.toString();
    }

    @Override
    public Optional<ResourceLocation> getTagEquivalent(Collection<T> ingredients) {
        return TagUtil.getTagEquivalent(ingredients, this.fluidType::getBase, () -> ((DefaultedRegistry)BuiltInRegistries.FLUID).getTags());
    }
}

