/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.neoforge.network;

import java.util.Locale;
import mezz.jei.common.config.IServerConfig;
import mezz.jei.common.network.ClientPacketRouter;
import mezz.jei.common.network.IConnectionToClient;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.PacketIdClient;
import mezz.jei.common.network.PacketIdServer;
import mezz.jei.common.network.ServerPacketRouter;
import mezz.jei.common.network.packets.PacketJeiToClient;
import mezz.jei.common.network.packets.PacketJeiToServer;
import mezz.jei.neoforge.events.PermanentEventSubscriptions;
import mezz.jei.neoforge.network.WrappingPayload;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;

public class NetworkHandler {
    private static final String TO_CLIENT_NAMESPACE = "jei_to_client";
    private static final String TO_SERVER_NAMESPACE = "jei_to_server";
    private final ResourceLocation channelId;
    private final String protocolVersion;
    private final IServerConfig serverConfig;

    public NetworkHandler(ResourceLocation channelId, String protocolVersion, IServerConfig serverConfig) {
        this.channelId = channelId;
        this.protocolVersion = protocolVersion;
        this.serverConfig = serverConfig;
    }

    public ResourceLocation getChannelId() {
        return this.channelId;
    }

    public void registerServerPacketHandler(ServerPacketRouter packetRouter, IConnectionToClient connection, PermanentEventSubscriptions subscriptions) {
        subscriptions.register(RegisterPayloadHandlerEvent.class, ev -> {
            IPayloadRegistrar registrar = ev.registrar(TO_SERVER_NAMESPACE).versioned(this.protocolVersion).optional();
            packetRouter.handlers.forEach((key, value) -> {
                ResourceLocation name = NetworkHandler.toServerID(key);
                registrar.play(name, buf -> new WrappingPayload<PacketJeiToServer>(value.readPacketData((FriendlyByteBuf)buf), name), (packet, context) -> WrappingPayload.processToServer(packet, context, connection, this.serverConfig));
            });
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClientPacketHandler(ClientPacketRouter packetRouter, IConnectionToServer connection, PermanentEventSubscriptions subscriptions) {
        subscriptions.register(RegisterPayloadHandlerEvent.class, ev -> {
            IPayloadRegistrar registrar = ev.registrar(TO_CLIENT_NAMESPACE).versioned(this.protocolVersion).optional();
            packetRouter.clientHandlers.forEach((key, value) -> {
                ResourceLocation name = NetworkHandler.toClientID(key);
                registrar.play(name, buf -> new WrappingPayload<PacketJeiToClient>(value.readPacketData((FriendlyByteBuf)buf), name), (packet, context) -> WrappingPayload.processToClient(packet, context, connection, this.serverConfig));
            });
        });
    }

    public static ResourceLocation toServerID(PacketIdServer id) {
        return new ResourceLocation(TO_SERVER_NAMESPACE, id.name().toLowerCase(Locale.ROOT));
    }

    public static ResourceLocation toClientID(PacketIdClient id) {
        return new ResourceLocation(TO_CLIENT_NAMESPACE, id.name().toLowerCase(Locale.ROOT));
    }
}

