/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.neoforge.platform;

import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.common.platform.IPlatformIngredientHelper;
import mezz.jei.neoforge.ingredients.JeiIngredient;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class IngredientHelper
implements IPlatformIngredientHelper {
    @Override
    public Ingredient createShulkerDyeIngredient(DyeColor color) {
        DyeItem dye = DyeItem.byColor((DyeColor)color);
        ItemStack dyeStack = new ItemStack((ItemLike)dye);
        TagKey colorTag = color.getTag();
        Ingredient.ItemValue dyeList = new Ingredient.ItemValue(dyeStack);
        Ingredient.TagValue colorList = new Ingredient.TagValue(colorTag);
        Stream<Ingredient.Value> colorIngredientStream = Stream.of(dyeList, colorList);
        return Ingredient.fromValues(colorIngredientStream);
    }

    @Override
    public Ingredient createNbtIngredient(ItemStack stack, IStackHelper stackHelper) {
        return new JeiIngredient(stack, stackHelper);
    }

    @Override
    public List<Ingredient> getPotionContainers() {
        return PotionBrewing.ALLOWED_CONTAINERS;
    }
}

