/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.neoforge.platform;

import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.common.platform.IPlatformRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class RegistryWrapper<T>
implements IPlatformRegistry<T> {
    private final Registry<T> registry;

    public static <T> IPlatformRegistry<T> getRegistry(ResourceKey<? extends Registry<T>> key) {
        RegistryWrapper<T> registryWrapper;
        Registry rootRegistry = BuiltInRegistries.REGISTRY;
        Registry registry = (Registry)rootRegistry.get(key.location());
        if (registry == null) {
            throw new NullPointerException("Could not find registry for key: " + key);
        }
        RegistryWrapper<T> castPlatformRegistry = registryWrapper = new RegistryWrapper<T>(registry);
        return castPlatformRegistry;
    }

    private RegistryWrapper(Registry<T> registry) {
        this.registry = registry;
    }

    @Override
    public Stream<T> getValues() {
        return this.registry.stream();
    }

    @Override
    public Optional<T> getValue(ResourceLocation resourceLocation) {
        Object t = this.registry.get(resourceLocation);
        return Optional.ofNullable(t);
    }

    @Override
    public int getId(T entry) {
        return this.registry.getId(entry);
    }

    @Override
    public Optional<T> getValue(int id) {
        return this.registry.getHolder(id).map(Holder::value);
    }

    @Override
    public boolean contains(T entry) {
        return this.registry.getKey(entry) != null;
    }

    @Override
    public Optional<ResourceLocation> getRegistryName(T entry) {
        return this.registry.getResourceKey(entry).map(ResourceKey::location);
    }
}

