/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.api.RenderManager;
import de.bluecolored.bluemap.api.WebApp;
import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.api.plugin.Plugin;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;

public abstract class BlueMapAPI {
    private static final String VERSION;
    private static final String GIT_HASH;
    private static BlueMapAPI instance;
    private static final LinkedHashSet<Consumer<BlueMapAPI>> onEnableConsumers;
    private static final LinkedHashSet<Consumer<BlueMapAPI>> onDisableConsumers;

    @DebugDump
    public abstract RenderManager getRenderManager();

    @DebugDump
    public abstract WebApp getWebApp();

    @DebugDump
    public abstract Plugin getPlugin();

    @DebugDump
    public abstract Collection<BlueMapMap> getMaps();

    @DebugDump
    public abstract Collection<BlueMapWorld> getWorlds();

    public abstract Optional<BlueMapWorld> getWorld(Object var1);

    public abstract Optional<BlueMapMap> getMap(String var1);

    @DebugDump
    public abstract String getBlueMapVersion();

    @DebugDump
    public String getAPIVersion() {
        return VERSION;
    }

    public static synchronized Optional<BlueMapAPI> getInstance() {
        return Optional.ofNullable(instance);
    }

    public static synchronized void onEnable(Consumer<BlueMapAPI> consumer) {
        onEnableConsumers.add(consumer);
        if (instance != null) {
            consumer.accept(instance);
        }
    }

    public static synchronized void onDisable(Consumer<BlueMapAPI> consumer) {
        onDisableConsumers.add(consumer);
    }

    public static synchronized boolean unregisterListener(Consumer<BlueMapAPI> consumer) {
        return onEnableConsumers.remove(consumer) | onDisableConsumers.remove(consumer);
    }

    /*
     * WARNING - void declaration
     */
    protected static synchronized boolean registerInstance(BlueMapAPI instance) throws ExecutionException {
        if (BlueMapAPI.instance != null) {
            return false;
        }
        BlueMapAPI.instance = instance;
        ArrayList<Throwable> thrownExceptions = new ArrayList<Throwable>(0);
        for (Consumer consumer : onEnableConsumers) {
            try {
                consumer.accept(BlueMapAPI.instance);
            }
            catch (Throwable ex) {
                thrownExceptions.add(ex);
            }
        }
        if (!thrownExceptions.isEmpty()) {
            void var3_5;
            ExecutionException ex = new ExecutionException((Throwable)thrownExceptions.get(0));
            boolean bl = true;
            while (var3_5 < thrownExceptions.size()) {
                ex.addSuppressed((Throwable)thrownExceptions.get((int)var3_5));
                ++var3_5;
            }
            throw ex;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected static synchronized boolean unregisterInstance(BlueMapAPI instance) throws ExecutionException {
        if (BlueMapAPI.instance != instance) {
            return false;
        }
        ArrayList<Exception> thrownExceptions = new ArrayList<Exception>(0);
        for (Consumer consumer : onDisableConsumers) {
            try {
                consumer.accept(BlueMapAPI.instance);
            }
            catch (Exception ex) {
                thrownExceptions.add(ex);
            }
        }
        BlueMapAPI.instance = null;
        if (!thrownExceptions.isEmpty()) {
            void var3_5;
            ExecutionException ex = new ExecutionException((Throwable)thrownExceptions.get(0));
            boolean bl = true;
            while (var3_5 < thrownExceptions.size()) {
                ex.addSuppressed((Throwable)thrownExceptions.get((int)var3_5));
                ++var3_5;
            }
            throw ex;
        }
        return true;
    }

    static {
        String version = "DEV";
        String gitHash = "DEV";
        URL url = BlueMapAPI.class.getResource("/de/bluecolored/bluemap/api/version.json");
        if (url != null) {
            Gson gson = new Gson();
            try (InputStream in = url.openStream();
                 InputStreamReader reader = new InputStreamReader(in);){
                JsonObject element = ((JsonElement)gson.fromJson((Reader)reader, JsonElement.class)).getAsJsonObject();
                version = element.get("version").getAsString();
                gitHash = element.get("git-hash").getAsString();
            }
            catch (Exception ex) {
                System.err.println("Failed to load version from resources!");
                ex.printStackTrace();
            }
        }
        if (version.equals("${version}")) {
            version = "DEV";
        }
        if (gitHash.equals("${gitHash}")) {
            version = "DEV";
        }
        VERSION = version;
        GIT_HASH = gitHash;
        onEnableConsumers = new LinkedHashSet();
        onDisableConsumers = new LinkedHashSet();
    }
}

