/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api.gson;

import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import de.bluecolored.bluemap.api.markers.ExtrudeMarker;
import de.bluecolored.bluemap.api.markers.HtmlMarker;
import de.bluecolored.bluemap.api.markers.LineMarker;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.POIMarker;
import de.bluecolored.bluemap.api.markers.ShapeMarker;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Line;
import de.bluecolored.bluemap.api.math.Shape;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.Map;

public final class MarkerGson {
    public static final Gson INSTANCE = MarkerGson.addAdapters(new GsonBuilder()).setLenient().create();

    private MarkerGson() {
    }

    public static GsonBuilder addAdapters(GsonBuilder builder) {
        return builder.registerTypeAdapter(Marker.class, (Object)new MarkerDeserializer()).registerTypeAdapter(Marker.class, (Object)new MarkerSerializer()).registerTypeAdapter(Line.class, (Object)new LineAdapter()).registerTypeAdapter(Shape.class, (Object)new ShapeAdapter()).registerTypeAdapter(Color.class, (Object)new ColorAdapter()).registerTypeAdapter(Vector2d.class, (Object)new Vector2dAdapter()).registerTypeAdapter(Vector3d.class, (Object)new Vector3dAdapter()).registerTypeAdapter(Vector2i.class, (Object)new Vector2iAdapter()).registerTypeAdapter(Vector3i.class, (Object)new Vector3iAdapter());
    }

    static class MarkerDeserializer
    implements JsonDeserializer<Marker> {
        private static final Map<String, Class<? extends Marker>> MARKER_TYPES = Map.of("html", HtmlMarker.class, "poi", POIMarker.class, "shape", ShapeMarker.class, "extrude", ExtrudeMarker.class, "line", LineMarker.class);

        MarkerDeserializer() {
        }

        public Marker deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            String markerType = jsonElement.getAsJsonObject().get("type").getAsString();
            Class<? extends Marker> markerClass = MARKER_TYPES.get(markerType);
            if (markerClass == null) {
                throw new JsonParseException("Unknown marker type: " + markerType);
            }
            return (Marker)context.deserialize(jsonElement, markerClass);
        }
    }

    static class MarkerSerializer
    implements JsonSerializer<Marker> {
        MarkerSerializer() {
        }

        public JsonElement serialize(Marker src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src, src.getClass());
        }
    }

    static class LineAdapter
    extends TypeAdapter<Line> {
        private static final Vector3dAdapter VEC3D_ADAPTER = new Vector3dAdapter();

        LineAdapter() {
        }

        public void write(JsonWriter out, Line value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (Vector3d point : value.getPoints()) {
                VEC3D_ADAPTER.write(out, point);
            }
            out.endArray();
        }

        public Line read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            LinkedList<Vector3d> points = new LinkedList<Vector3d>();
            in.beginArray();
            while (in.peek() != JsonToken.END_ARRAY) {
                Vector3d point = VEC3D_ADAPTER.read(in);
                if (point == null) continue;
                points.add(point);
            }
            in.endArray();
            return new Line((Vector3d[])points.toArray(Vector3d[]::new));
        }
    }

    static class ShapeAdapter
    extends TypeAdapter<Shape> {
        private static final Vector2dAdapter VEC2D_ADAPTER = new Vector2dAdapter(true);

        ShapeAdapter() {
        }

        public void write(JsonWriter out, Shape value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (Vector2d point : value.getPoints()) {
                VEC2D_ADAPTER.write(out, point);
            }
            out.endArray();
        }

        public Shape read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            LinkedList<Vector2d> points = new LinkedList<Vector2d>();
            in.beginArray();
            while (in.peek() != JsonToken.END_ARRAY) {
                Vector2d point = VEC2D_ADAPTER.read(in);
                if (point == null) continue;
                points.add(point);
            }
            in.endArray();
            return new Shape((Vector2d[])points.toArray(Vector2d[]::new));
        }
    }

    static class ColorAdapter
    extends TypeAdapter<Color> {
        ColorAdapter() {
        }

        public void write(JsonWriter out, Color value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("r");
            out.value((long)value.getRed());
            out.name("g");
            out.value((long)value.getGreen());
            out.name("b");
            out.value((long)value.getBlue());
            out.name("a");
            out.value((double)value.getAlpha());
            out.endObject();
        }

        public Color read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            int r = 0;
            int g2 = 0;
            int b = 0;
            float a = 1.0f;
            block12: while (in.peek() != JsonToken.END_OBJECT) {
                switch (in.nextName()) {
                    case "r": {
                        r = in.nextInt();
                        continue block12;
                    }
                    case "g": {
                        g2 = in.nextInt();
                        continue block12;
                    }
                    case "b": {
                        b = in.nextInt();
                        continue block12;
                    }
                    case "a": {
                        a = (float)in.nextDouble();
                        continue block12;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return new Color(r, g2, b, a);
        }
    }

    static class Vector2dAdapter
    extends TypeAdapter<Vector2d> {
        private final boolean useZ;

        public Vector2dAdapter() {
            this.useZ = false;
        }

        public Vector2dAdapter(boolean useZ) {
            this.useZ = useZ;
        }

        public void write(JsonWriter out, Vector2d value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("x");
            out.value(value.getX());
            out.name(this.useZ ? "z" : "y");
            out.value(value.getY());
            out.endObject();
        }

        public Vector2d read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            double x = 0.0;
            double y = 0.0;
            block10: while (in.peek() != JsonToken.END_OBJECT) {
                switch (in.nextName()) {
                    case "x": {
                        x = in.nextDouble();
                        continue block10;
                    }
                    case "y": {
                        if (!this.useZ) {
                            y = in.nextDouble();
                            continue block10;
                        }
                        in.skipValue();
                        continue block10;
                    }
                    case "z": {
                        if (this.useZ) {
                            y = in.nextDouble();
                            continue block10;
                        }
                        in.skipValue();
                        continue block10;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return new Vector2d(x, y);
        }
    }

    static class Vector3dAdapter
    extends TypeAdapter<Vector3d> {
        Vector3dAdapter() {
        }

        public void write(JsonWriter out, Vector3d value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("x");
            out.value(value.getX());
            out.name("y");
            out.value(value.getY());
            out.name("z");
            out.value(value.getZ());
            out.endObject();
        }

        public Vector3d read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            block10: while (in.peek() != JsonToken.END_OBJECT) {
                switch (in.nextName()) {
                    case "x": {
                        x = in.nextDouble();
                        continue block10;
                    }
                    case "y": {
                        y = in.nextDouble();
                        continue block10;
                    }
                    case "z": {
                        z = in.nextDouble();
                        continue block10;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return new Vector3d(x, y, z);
        }
    }

    static class Vector2iAdapter
    extends TypeAdapter<Vector2i> {
        Vector2iAdapter() {
        }

        public void write(JsonWriter out, Vector2i value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("x");
            out.value((long)value.getX());
            out.name("y");
            out.value((long)value.getY());
            out.endObject();
        }

        public Vector2i read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            int x = 0;
            int y = 0;
            block8: while (in.peek() != JsonToken.END_OBJECT) {
                switch (in.nextName()) {
                    case "x": {
                        x = in.nextInt();
                        continue block8;
                    }
                    case "y": {
                        y = in.nextInt();
                        continue block8;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return new Vector2i(x, y);
        }
    }

    static class Vector3iAdapter
    extends TypeAdapter<Vector3i> {
        Vector3iAdapter() {
        }

        public void write(JsonWriter out, Vector3i value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("x");
            out.value((long)value.getX());
            out.name("y");
            out.value((long)value.getY());
            out.name("z");
            out.value((long)value.getZ());
            out.endObject();
        }

        public Vector3i read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            int x = 0;
            int y = 0;
            int z = 0;
            block10: while (in.peek() != JsonToken.END_OBJECT) {
                switch (in.nextName()) {
                    case "x": {
                        x = in.nextInt();
                        continue block10;
                    }
                    case "y": {
                        y = in.nextInt();
                        continue block10;
                    }
                    case "z": {
                        z = in.nextInt();
                        continue block10;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return new Vector3i(x, y, z);
        }
    }
}

