/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api.markers;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.api.markers.Marker;

@DebugDump
public abstract class DistanceRangedMarker
extends Marker {
    private double minDistance = 0.0;
    private double maxDistance = 1.0E7;

    public DistanceRangedMarker(String type, String label, Vector3d position) {
        super(type, label, position);
    }

    public double getMinDistance() {
        return this.minDistance;
    }

    public void setMinDistance(double minDistance) {
        this.minDistance = minDistance;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(double maxDistance) {
        this.maxDistance = maxDistance;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DistanceRangedMarker that = (DistanceRangedMarker)o;
        if (Double.compare(that.minDistance, this.minDistance) != 0) {
            return false;
        }
        return Double.compare(that.maxDistance, this.maxDistance) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.minDistance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxDistance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public static abstract class Builder<T extends DistanceRangedMarker, B extends Builder<T, B>>
    extends Marker.Builder<T, B> {
        Double minDistance;
        Double maxDistance;

        public B minDistance(double minDistance) {
            this.minDistance = minDistance;
            return (B)((Builder)this.self());
        }

        public B maxDistance(double maxDistance) {
            this.maxDistance = maxDistance;
            return (B)((Builder)this.self());
        }

        @Override
        T build(T marker) {
            if (this.minDistance != null) {
                ((DistanceRangedMarker)marker).setMinDistance(this.minDistance);
            }
            if (this.maxDistance != null) {
                ((DistanceRangedMarker)marker).setMaxDistance(this.maxDistance);
            }
            return (T)((DistanceRangedMarker)super.build(marker));
        }
    }
}

