/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api.markers;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.api.markers.ObjectMarker;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Line;
import java.util.Objects;

@DebugDump
public class LineMarker
extends ObjectMarker {
    private static final Line DEFAULT_LINE = new Line(Vector3d.ZERO, Vector3d.ONE);
    private Line line;
    private boolean depthTest = true;
    private int lineWidth = 2;
    private Color lineColor = new Color(255, 0, 0, 1.0f);

    private LineMarker() {
        this("", DEFAULT_LINE);
    }

    public LineMarker(String label, Line line) {
        this(label, LineMarker.calculateLineCenter(Objects.requireNonNull(line, "line must not be null")), line);
    }

    public LineMarker(String label, Vector3d position, Line line) {
        super("line", label, position);
        this.line = Objects.requireNonNull(line, "line must not be null");
    }

    public Line getLine() {
        return this.line;
    }

    public void setLine(Line line) {
        this.line = Objects.requireNonNull(line, "line must not be null");
    }

    public void centerPosition() {
        this.setPosition(LineMarker.calculateLineCenter(this.line));
    }

    public boolean isDepthTestEnabled() {
        return this.depthTest;
    }

    public void setDepthTestEnabled(boolean enabled) {
        this.depthTest = enabled;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = Objects.requireNonNull(color, "color must not be null");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LineMarker that = (LineMarker)o;
        if (this.depthTest != that.depthTest) {
            return false;
        }
        if (this.lineWidth != that.lineWidth) {
            return false;
        }
        if (!this.line.equals(that.line)) {
            return false;
        }
        return this.lineColor.equals(that.lineColor);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.line.hashCode();
        result = 31 * result + (this.depthTest ? 1 : 0);
        result = 31 * result + this.lineWidth;
        result = 31 * result + this.lineColor.hashCode();
        return result;
    }

    private static Vector3d calculateLineCenter(Line line) {
        return line.getMin().add(line.getMax()).mul(0.5);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ObjectMarker.Builder<LineMarker, Builder> {
        Line line;
        Boolean depthTest;
        Integer lineWidth;
        Color lineColor;

        public Builder line(Line line) {
            this.line = line;
            return this;
        }

        public Builder centerPosition() {
            this.position(null);
            return this;
        }

        public Builder depthTestEnabled(boolean enabled) {
            this.depthTest = enabled;
            return this;
        }

        public Builder lineWidth(int width) {
            this.lineWidth = width;
            return this;
        }

        public Builder lineColor(Color color) {
            this.lineColor = color;
            return this;
        }

        @Override
        public LineMarker build() {
            LineMarker marker = new LineMarker(this.checkNotNull(this.label, "label"), this.checkNotNull(this.line, "line"));
            if (this.depthTest != null) {
                marker.setDepthTestEnabled(this.depthTest);
            }
            if (this.lineWidth != null) {
                marker.setLineWidth(this.lineWidth);
            }
            if (this.lineColor != null) {
                marker.setLineColor(this.lineColor);
            }
            return this.build(marker);
        }
    }
}

